% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/air.R
\name{echoAirGetFacilityInfo}
\alias{echoAirGetFacilityInfo}
\title{Downloads EPA ECHO permitted air emitter information}
\usage{
echoAirGetFacilityInfo(output = "df", verbose = FALSE, ...)
}
\arguments{
\item{output}{Character string specifying output format. \code{output = 'df'} for a dataframe or \code{output = 'sf'} for a simple features spatial dataframe. See (\url{https://CRAN.R-project.org/package=sf}) for more information about simple features.}

\item{verbose}{Logical, indicating whether to provide processing and retrieval messages. Defaults to FALSE}

\item{...}{Further arguments passed as query parameters in request sent to EPA ECHO's API. For more options see: \url{https://echo.epa.gov/tools/web-services/facility-search-water#!/Facility_Information/get_air_rest_services_get_facility_info} for a complete list of parameter options. Examples provided below.}
}
\value{
dataframe or sf dataframe suitable for plotting
}
\description{
Returns a dataframe or simplefeature dataframe of permitted facilities returned by the query.
Uses EPA's ECHO API: \url{https://echo.epa.gov/tools/web-services/facility-search-air#!/Facilities/get_air_rest_services_get_facility_info}
}
\examples{
\donttest{
## These examples require an internet connection to run

## Retrieve table of facilities by bounding box
echoAirGetFacilityInfo(xmin = '-96.407563',
ymin = '30.554395',
xmax = '-96.25947',
ymax = '30.751984',
output = 'df')

## Retrieve a simple features dataframe by bounding box
spatialdata <- echoAirGetFacilityInfo(xmin = '-96.407563',
ymin = '30.554395',
xmax = '-96.25947',
ymax = '30.751984',
output = 'sf')

}
}
