% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{vd_LL_vdmss}
\alias{vd_LL_vdmss}
\title{Log-Likelihood for volumetric demand model with set-size variation}
\usage{
vd_LL_vdmss(draw, vd, fromdraw = 1)
}
\arguments{
\item{draw}{A list, 'echoice2' draws object}

\item{vd}{A tibble, tidy choice data (before dummy-coding)}

\item{fromdraw}{An integer, from which draw onwards to compute LL (i.e., excl. burnin)}
}
\value{
N x Draws Matrix of log-Likelihood values
}
\description{
Log-Likelihood for volumetric demand model with set-size variation
}
\examples{
data(icecream)
#fit model
#note: this is just for demo purposes
#on this demo dataset, the model is not identified
#due to a lack of set size variation
icecream_est <- icecream \%>\% vd_est_vdm_ss(R=10, keep=1, cores=2)
#compute likelihood for each subject in each draw
loglls<-vd_LL_vdmss(icecream_est, icecream, fromdraw = 2)
#300 respondents, 10 draws
dim(loglls)
}
