% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ecr.band}
\alias{ecr.band}
\title{Area band}
\usage{
ecr.band(df = NULL, lower = NULL, upper = NULL, type = "polygon", ...)
}
\arguments{
\item{df}{A data.frame with lower and upper numerical columns and first column with X coordinates.}

\item{lower}{The column name(string) of band's lower boundary.}

\item{upper}{The column name(string) of band's upper boundary.}

\item{type}{Type of rendering  \cr \itemize{
\item 'stack' - by two \href{https://echarts.apache.org/en/option.html#series-line.stack}{stacked lines}
\item 'polygon' - by drawing a polygon as polyline (default)
}}

\item{...}{More parameters for \href{https://echarts.apache.org/en/option.html#series-line.type}{serie}}
}
\value{
A list of one serie when type='polygon', or two series when type='stack'
}
\description{
A 'custom' serie with lower and upper boundaries
}
\details{
When type='polygon', coordinates of the two boundaries are chained into a polygon and displayed as one.\cr
When type='stack', two smooth \emph{stacked} lines are drawn, one with customizable areaStyle. The upper boundary coordinates should be values added on top of the lower boundary coordinates.\cr
Type 'stack' needs \emph{xAxis} to be of type 'category'.
}
\examples{
df <- data.frame( x = 1:10, y = runif(10, 5, 10)) \%>\%
  dplyr::mutate(lwr = y-runif(10, 1, 3), upr = y+runif(10, 2, 4))

p <- df \%>\% ec.init(load='custom')
p$x$opts$legend <- list(ey='') 
p$x$opts$xAxis <- list(type='category', boundaryGap=FALSE)
p$x$opts$series <- list(list(type='line', color='yellow', datasetIndex=0, name='line1'))
p$x$opts$series <- append( p$x$opts$series,
     ecr.band(df, 'lwr', 'upr', type='stack', name='stak')
)
p$x$opts$tooltip <- list(trigger = 'axis'
                         ,formatter = htmlwidgets::JS("function(x) {
  let str='high <b>'+x[2].value[2]+'</b><br>line <b>'+x[0].value[1]+
   '</b><br>low <b>'+x[1].value[1]+'</b>';
  return str;
  }"))
p

}
