% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{band2}
\alias{band2}
\alias{e_band2}
\alias{e_band2_}
\title{Area bands}
\usage{
e_band2(e, lower, upper, ...)

e_band2_(
  e,
  lower,
  upper,
  name = NULL,
  legend = TRUE,
  y_index = 0,
  x_index = 0,
  coord_system = "cartesian2d",
  itemStyle = list(borderWidth = 0.5),
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{lower, upper}{series of lower and upper borders of the band}

\item{...}{additional options}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{y_index}{Indexes of x and y axis.}

\item{x_index}{Indexes of x and y axis.}

\item{coord_system}{Coordinate system to plot against.}

\item{itemStyle}{mostly used for borderWidth, default 0.5}
}
\description{
Add area bands
}
\examples{
data(EuStockMarkets)
as.data.frame(EuStockMarkets) \%>\%
  dplyr::slice_head(n = 200) \%>\%
  dplyr::mutate(day = 1:dplyr::n()) \%>\%
  e_charts(day) \%>\%
  e_line(CAC, symbol = "none") \%>\%
  e_band2(DAX, FTSE, color = "lemonchiffon") \%>\%
  e_band2(DAX, SMI, color = "lightblue", itemStyle = list(borderWidth = 0)) \%>\%
  e_y_axis(scale = TRUE) \%>\%
  e_datazoom(start = 50)
}
