% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{e_axis}
\alias{e_axis}
\alias{e_x_axis}
\alias{e_y_axis}
\alias{e_z_axis}
\alias{e_rm_axis}
\alias{e_axis_formatter}
\title{Axis}
\usage{
e_axis(e, axis = c("x", "y", "z"), index = 0, formatter = NULL, ...)

e_x_axis(e, index = 0, formatter = NULL, ...)

e_y_axis(e, index = 0, formatter = NULL, ...)

e_z_axis(e, index = 0, ...)

e_rm_axis(e, axis = c("x", "y", "z"))

e_axis_formatter(style = c("decimal", "percent", "currency"),
  digits = 0, locale = NULL, currency = "USD")
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{axis}{Axis to customise.}

\item{index}{Index of axis to customise.}

\item{formatter}{An axis formatter as returned by \code{\link{e_axis_formatter}}.}

\item{...}{Any other option to pass, check See Also section.}

\item{style}{Formatter style, one of \code{decimal}, \code{percent}, or \code{currency}.}

\item{digits}{Number of decimals.}

\item{locale}{Locale, if \code{NULL} then it is inferred from \code{Sys.getlocale}.}

\item{currency}{Currency to to display.}
}
\description{
Customise axis.
}
\section{Functions}{

\itemize{
  \item{\code{e_axis} to customise axis}
  \item{\code{e_rm_axis} to remove axis}
}
}

\examples{
# hide axis
USArrests \%>\% 
  e_charts(Assault) \%>\% 
  e_line(Murder, smooth = TRUE) \%>\% 
  e_line(Rape, y.index = 1) \%>\% # add secondary axis
  e_y_axis(index = 1, show = FALSE) # hide secondary axis
  
# use formatter
cars \%>\% 
  dplyr::mutate(
    speed = speed / 25
  ) \%>\% 
  e_charts(speed) \%>\% 
  e_scatter(dist) \%>\% 
  e_y_axis(
    formatter = e_axis_formatter("currency")
  ) \%>\% 
  e_x_axis(
    formatter = e_axis_formatter("percent", digits = 0)
  )

# plot all labels & rotate
USArrests \%>\% 
  head(10) \%>\% 
  dplyr::mutate(State = row.names(.)) \%>\% 
  e_charts(State) \%>\% 
  e_area(Murder) \%>\% 
  e_x_axis(axisLabel = list(interval = 0, rotate = 45)) # rotate
  
  
}
\seealso{
\href{https://ecomfe.github.io/echarts-doc/public/en/option.html#xAxis}{Additional x arguments}, 
\href{https://ecomfe.github.io/echarts-doc/public/en/option.html#yAxis}{Additional y arguments}
}
