% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdfHT.R
\docType{package}
\name{ecdfHT-package}
\alias{ecdfHT-package}
\title{ecdfHT: A package to plot an empirical cdf for heavy tailed data}
\description{
The \code{ecdfHT} package computes and plot a transformed empirical cdf for data.
This is useful because a standard empirical cdf (ecdf) gives little information
about the tails of the data when there are extreme values.
}
\details{
The transform is nonparametric: linear in the middle of the data and matched to a log-log
transform on the tails, where the tail regions  are determined by quantiles.
If the data has power law behavior on the tails, the plot is linear on those tails,
so this plot can be used as a graphical diagnostic to determine if a data set is heavy tailed.

In addition, there are functions to
\itemize{
\item annotate the plot, add custom axes and grid lines
\item overlay proposed models on the plot
\item fit the tails using linear regression on the transformed tails
\item combine the empirical cdf in the middle and the above fit on the tails to get a semi-parametric fit to the data
\item compute cdf, pdf, quantiles, and simulate from the semi-parametric fit
\item some multivariate plots that look at tail behavior of multiple components and some idea of the dependence.
}

I will try to fix the code if you provide a simple demonstration of a bug.  Polite suggestions for
improvements will be considered if there is time available.
}
\seealso{
\code{\link{ecdfHT}} for a basic plot,
\code{\link{ecdfHT.draw}} for annotations and additions to a basic plot,
\code{\link{ecdfHT.fit}} to fit a semi-parametric model to the data,
\code{\link{pecdfHT}} to compute the cdf, pdf, quantiles and simulate from a
semi-parametric model,
\code{\link{ecdfHT.multivar}} for multivariate generalizations.
}

