% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecop-bs-option-price-method.R
\name{ecop.bs_option_price}
\alias{ecop.bs_option_price}
\alias{ecop.bs_call_price}
\alias{ecop.bs_put_price}
\title{Calculate option price from implied volatility in Black-Sholes model}
\usage{
ecop.bs_option_price(ivol, K, S, ttm, int_rate = 0, div_yield = 0, otype = "c")

ecop.bs_call_price(ivol, K, S, ttm, int_rate = 0, div_yield = 0)

ecop.bs_put_price(ivol, K, S, ttm, int_rate = 0, div_yield = 0)
}
\arguments{
\item{ivol}{numeric vector of implied volatility}

\item{K}{numeric vector of strike prices}

\item{S}{length-one numeric for underlying price}

\item{ttm}{length-one numeric for time to maturity, in the unit of days/365.}

\item{int_rate}{length-one numeric for risk-free rate, default to 0.}

\item{div_yield}{length-one numeric for dividend yield, default to 0.}

\item{otype}{character, \code{c} or \code{p}. Default is \code{c}.}
}
\value{
The call/put prices
}
\description{
This is the standard library to calculate option price from
implied volatility \eqn{\sigma_{BS}} in Black-Sholes model.
There is no external dependency on elliptic distribution.
}
\examples{
ivol <- c(0.128886, 0.294296) 
K <- c(2100, 2040)
S <- 2089.27
T <- 1/365
y <- 0.019
ecop.bs_option_price(ivol, K, S, ttm=T, div_yield=y, otype="c")
# expect output of c(1.8, 50)
}
\keyword{ecop}
