% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecop-bs-implied-volatility-method.R
\name{ecop.bs_implied_volatility}
\alias{ecop.bs_implied_volatility}
\title{Implied volatility of Black-Sholes model}
\usage{
ecop.bs_implied_volatility(V, K, S, ttm, int_rate = 0, div_yield = 0,
  otype = "c", stop.on.na = FALSE, use.mc = TRUE)
}
\arguments{
\item{V}{numeric vector of option prices}

\item{K}{numeric vector of strike prices}

\item{S}{length-one numeric for underlying price}

\item{ttm}{length-one numeric for time to maturity, in the unit of days/365.}

\item{int_rate}{length-one numeric for risk-free rate, default to 0.}

\item{div_yield}{length-one numeric for dividend yield, default to 0.}

\item{otype}{character, specifying option type: \code{c} or \code{p}.}

\item{stop.on.na}{logical, to stop if fails to find solution.
Default is to use NaN and not stop.}

\item{use.mc}{logical, to use mclapply (default), or else just use for loop.
For loop option is typically for debugging.}
}
\value{
The implied volatity \eqn{\sigma_{BS}}.
}
\description{
This is the standard library to calculate implied volatility \eqn{\sigma_{BS}}
in Black-Sholes model.
There is no external dependency on elliptic distribution.
}
\examples{
V <- c(1.8, 50)
K <- c(2100, 2040)
S <- 2089.27
T <- 1/365
y <- 0.019
ecop.bs_implied_volatility(V, K, S, ttm=T, div_yield=y, otype="c")
# expect output of 12.8886\% and 29.4296\%
}
\keyword{ecop}
