% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecop-find-fixed-point-sd-by-lambda-method.R
\name{ecop.find_fixed_point_sd_by_lambda}
\alias{ecop.find_fixed_point_sd_by_lambda}
\title{Utility to find the fixed point stdev when lambda is given}
\usage{
ecop.find_fixed_point_sd_by_lambda(fn_get_ld1, lambda, beta = 0,
  otype = "c", verbose = FALSE)
}
\arguments{
\item{fn_get_ld1}{function, takes stdev, lambda, beta as input, return ld1 object
via \code{ecop.get_ld_triple}. This closure function encapulates
mu_plus_ratio, epsilon_ratio, atm_imp_k.}

\item{lambda}{numeric, the lambda parameter. Must be positive. Default: 3.}

\item{beta}{numeric, the skewness parameter. Default: 0.}

\item{otype}{character, option type. Default: "c".}

\item{verbose}{boolean, print debug message. Default: \code{FALSE}.}
}
\value{
numeric, representing stdev.
}
\description{
This utility finds the fixed point stdev when lambda is given. Other smile related parameters
are abstracted away via the closure function \code{fn_get_ld1}.
This utility is used primarily to solve the fixed point ATM hypothesis (for VIX option smile).
Note that this utility alone is not the full solution. Another utility is needed to match
the ATM skew, and the two tails (via mu and epsilon).
\code{fn_get_ld1} should have the functional signature of \code{fn_get_ld1(sd, lambda, beta=0)}
and returns an ecld object accordingly.
}
\author{
Stephen H-T. Lihn
}
\keyword{fixed-point}

