% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecop-term-master-calculator-method.R
\name{ecop.term_master_calculator}
\alias{ecop.smile_data_calculator}
\alias{ecop.term_atm}
\alias{ecop.term_master_calculator}
\title{Master calculator for all the analytics of volatility smiles required for a date}
\usage{
ecop.term_master_calculator(symbol, date_str, int_rate = 0, div_yield = 0,
  config_file = NULL, extdata_dir = NULL)

ecop.smile_data_calculator(idx, df_day, master, int_rate, div_yield, otype)

ecop.term_atm(opt)
}
\arguments{
\item{symbol}{character pointing to the standard option data file}

\item{date_str}{character in the form of YYYY-MM-DD}

\item{int_rate}{numeric, the interest rate used to calculate BS implied volatility from market data}

\item{div_yield}{numeric, the vididend yield used to calculate BS implied volatility from market data}

\item{config_file}{character, config file from the quarter optimx fit}

\item{extdata_dir}{character, external data directory}

\item{idx}{integer, indicating the index of the option chain}

\item{df_day}{data frame for the day}

\item{master}{the list structure from the output of \code{ecop.term_master_calculator}}

\item{otype}{character, option type of p or c}

\item{opt}{the list structure from the output of \code{ecop.smile_data_calculator}}
}
\value{
The nested list containing all analytics of volatility smiles for a date.
        The first level keys are the date strings.
        The first level attributes are \code{quartic.config} which is a data frame, 
        lists of \code{days, volumes, classes}, and values of \code{undl_price, max_idx}.
}
\description{
This is all-in-one calculator. The inputs are symbol, date (YYYY-MM-DD), 
and quartic config file location, 
and the optional external data directory. The data structure and documentation here are really rough.
They are used to calcuate teh data needed for the quartic paper.
They need to be polished and refined after the quartic paper is released.
}
\keyword{structure}
\keyword{term}

