% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_read.R
\name{ebv_read}
\alias{ebv_read}
\title{Read data from an EBV netCDF}
\usage{
ebv_read(
  filepath,
  datacubepath = NULL,
  entity = NULL,
  timestep = 1,
  type = "r",
  scenario = NULL,
  metric = NULL,
  sparse = FALSE,
  ignore_RAM = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{filepath}{Character. Path to the netCDF file.}

\item{datacubepath}{Character. Optional. Default: NULL. Path to the datacube
(use \code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}). Alternatively, you can use the
scenario and metric argument to define which cube you want to access.}

\item{entity}{Character or Integer. Default is NULL. If the structure is 3D,
the entity argument is set to NULL. Else, a character string or single
integer value must indicate the entity of the 4D structure of the EBV
netCDFs.}

\item{timestep}{Integer or character. Select one or several timestep(s).
Either provide an integer value or list of values that refer(s) to the
index of the timestep(s) (minimum value: 1) or provide a date or list of
dates in ISO format, such as '2015-01-01'.}

\item{type}{Character. Choose between 'a', 'r' and 'da'. The first returns an
array or matrix object. The 'r' indicates that a SpatRaster object from the
terra package will be returned (default). The latter ('da') returns a
DelayedArray or DelayedMatrix object.}

\item{scenario}{Character or integer. Optional. Default: NULL. Define the
scenario you want to access. If the EBV netCDF has no scenarios, leave the
default value (NULL). You can use an integer value defining the scenario or
give the name of the scenario as a character string. To check the available
scenarios and their name or number (integer), use
\code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}.}

\item{metric}{Character or integer. Optional. Define the metric you want to
access. You can use an integer value defining the metric or give the name
of the scenario as a character string. To check the available metrics and
their name or number (integer), use \code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}.}

\item{sparse}{Logical. Default: FALSE. Set to TRUE if the data contains a lot
empty raster cells. Only relevant for DelayedArray return value.}

\item{ignore_RAM}{Logical. Default: FALSE. Checks if there is enough space in
your memory to read the data. Can be switched off (set to TRUE).}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
Array, SpatRaster or DelayedArray object containing the data of the
corresponding datacube and timestep(s).
}
\description{
Read one or more layers from one datacube of the netCDF file.
Decide between in-memory array, in-memory SpatRaster or an array-like
object (DelayedMatrix) pointing to the on-disk netCDF file. The latter is
useful for data that exceeds your memory.
}
\note{
For working with the DelayedMatrix take a look at
\code{\link[DelayedArray:DelayedArray-class]{DelayedArray::DelayedArray()}} and the
\href{https://www.rdocumentation.org/packages/HDF5Array/versions/1.0.2/topics/DelayedArray-utils}{DelayedArray-utils}.
}
\examples{
#set path to EBV netCDF
file <- system.file(file.path("extdata","martins_comcom_subset.nc"), package="ebvcube")
#get all datacubepaths of EBV netCDF
datacubes <- ebv_datacubepaths(file, verbose=FALSE)

\donttest{
#read data as DelayedArray
cSAR.delayedarray <- ebv_read(filepath = file, datacubepath = datacubes[1,1],
                              entity = 1, timestep = c(1,3), type='da',
                              sparse = TRUE)
#read data as SpatRaster
cSAR.raster <- ebv_read(filepath = file,entity = 1, timestep = "2000-01-01",
                        type='r', metric = 1)
#read data as Array
cSAR.array <- ebv_read(filepath = file, datacubepath = datacubes[1,1],
                              entity = 1, timestep = 1, type='r')
}
}
