% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-stixels.R
\name{stixel_footprint}
\alias{stixel_footprint}
\alias{plot.stixel_footprint}
\title{Calculate the spatial footprint of a set of stixels}
\usage{
stixel_footprint(path, ext)

\method{plot}{stixel_footprint}(x, ...)
}
\arguments{
\item{path}{character; full path to directory containing the eBird Status and
Trends products for a single species.}

\item{ext}{\link{ebirdst_extent} object; the spatiotemporal extent to filter the
data to.}

\item{x}{\link{stixel_footprint} object to map.}

\item{...}{ignored.}
}
\value{
A \link{stixel_footprint} object consisting of a list with three elements:
\itemize{
\item \code{footprint}: a \code{RasterStack} giving the percentage of the selected
stixels that are contributing to each grid cell.
\item \code{centroids}: an \link{sf} object containing the stixel centroids points.
\item \code{extent}: an \link{ebirdst_extent} object specifying the chosen spatiotemporal
extent.
}

The stixel footprint can be mapped by calling \code{\link[=plot]{plot()}} on the returned
\link{stixel_footprint} object.
}
\description{
eBird Status and Trends divides space and time into variably sized "stixels"
within which individual base models are fit. The process of stixelization is
performed many times and the prediction at any given point is the median of
the predictions from all the stixels that that point falls in. For a given
spatiotemporal extent, this function identifies the set of stixels whose
centroids fall within that extent and calculates the spatial footprint of
these stixels, i.e. a surface indicating the proportion of the selected
stixels that contribute information to model estimates at each location. This
footprint gives an estimate of where the information for the model
predictions, predictor importances (PIs), and partial dependencies (PDs) come
from.
}
\examples{
\donttest{
# download example data
path <- ebirdst_download("example_data")
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# define a spatiotemporal extent
bb_vec <- c(xmin = -86, xmax = -83, ymin = 42, ymax = 45)
e <- ebirdst_extent(bb_vec, t = c("05-01", "05-31"))

# calculate effective extent map
footprint <- stixel_footprint(path, ext = e)
plot(footprint)
}
}
