% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemTuples.R
\name{itemTuples}
\alias{itemTuples}
\title{Create item tuples.}
\usage{
itemTuples(items, idCol = "ID", infoCol, sepPattern = ", ")
}
\arguments{
\item{items}{A \code{data.frame} with information on an item pool.}

\item{idCol}{character or integer indicating the item ID column in \code{items}.}

\item{infoCol}{character or integer indicating the column in \code{items} which contains information on the tuples.}

\item{sepPattern}{String which should be used for separating item IDs in the \code{infoCol} column.}
}
\value{
A \code{data.frame} with two columns.
}
\description{
If item inclusions or exclusions are stored as a character vector, \code{itemTuples} separates this vector and creates item pairs ('tuples').
}
\details{
Tuples can be used by \code{\link{itemExclusionConstraint}} to set up exclusion constraints
and by \code{\link{itemInclusionConstraint}} to set up inclusion constraints. Note that a
separator pattern has to be used consistently throughout the column (e.g. \code{", "}).
}
\examples{
# Example data.frame
items <- data.frame(ID = c("item1", "item2", "item3", "item4"),
                     exclusions = c("item2, item3", NA, NA, NA))

# Create tuples
itemTuples(items = items, idCol = "ID", infoCol = 2,
                    sepPattern = ", ")


}
