% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preProcess.R
\name{preProcess}
\alias{preProcess}
\title{Data preprocessing}
\usage{
preProcess(
  data,
  x,
  y,
  numStop = 5,
  fold = 5,
  max.depth = NULL,
  max.leaves = NULL,
  na.rm = TRUE
)
}
\arguments{
\item{data}{Dataframe or matrix containing the variables in the model.}

\item{x}{Vector. Column input indexes in data.}

\item{y}{Vector. Column output indexes in data.}

\item{numStop}{Integer. Minimum number of observations in a node for a split to be attempted.}

\item{fold}{Integer. Set of number of folds in which the dataset to apply cross-validation during the pruning is divided.}

\item{max.depth}{Integer. Depth of the tree.}

\item{max.leaves}{Integer. Maximum number of leaf nodes.}

\item{na.rm}{Logical. If \code{TRUE}, \code{NA} rows are omitted.}
}
\value{
List containing rownames and data processed in the [X, Y] format with only categories allowed.
}
\description{
This function displays error messages in relation with data such as presence of NA values, types of data not allowed or arguments entered incorrectly. Also, it prepares the data in the required format.
}
