% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmat.R
\name{fmat}
\alias{fmat}
\title{Number Formatter}
\usage{
fmat(x = NULL, type = c("auto", ",", "$", "\%", ".", "mdy", "ymd",
  "date", "dollar", "dollars", "count", "percentage", "decimal"),
  do.return = c("formatted", "highcharter"), digits = NULL,
  with.unit = FALSE, do.date.sep = "/", do.remove.spaces = FALSE,
  digits.cutoff = NULL)
}
\arguments{
\item{x}{Vector of values to convert. If retu}

\item{type}{Type of format to return. If do.return == 'highcharter' this is not required.}

\item{do.return}{Information to return. "formatted" returns a vector of formatted values.}

\item{digits}{Number of digits for rounding. If left blank, the funtion will guess at the best digits.}

\item{with.unit}{For large numbers, choose to add a suffix for fewer characters, like M for million, etc.}

\item{do.date.sep}{Separator for date formatting.}

\item{do.remove.spaces}{Remove extra spaces in return.}

\item{digits.cutoff}{Amount at which to show 0 digits. Allows for flexibility of rounding.}
}
\value{
Information requested via do.return.
}
\description{
Flexible number formatter for easier formatting from numbers and dates into characters for display.
}
\examples{

fmat( 1000, 'dollar', digits = 2 )

}
