% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cens_get.R
\name{cens_get}
\alias{cens_get}
\alias{cens_get_dec}
\alias{cens_get_acs}
\title{Download data from a decennial census or ACS table}
\usage{
cens_get_dec(
  table,
  geo = NULL,
  ...,
  check_geo = FALSE,
  drop_total = FALSE,
  show_call = FALSE
)

cens_get_acs(
  table,
  geo = NULL,
  ...,
  year = 2019,
  survey = c("acs5", "acs1"),
  check_geo = FALSE,
  drop_total = FALSE,
  show_call = FALSE
)
}
\arguments{
\item{table}{The table to download, either as a character vector or a table
object as produced by \code{\link[=cens_find_dec]{cens_find_dec()}},  \code{\link[=cens_find_acs]{cens_find_acs()}} or
\code{\link[=cens_parse_tables]{cens_parse_tables()}}, or as included in \code{tables_dec} and \code{tables_acs}.
Note: some tables are split into A/B/C/etc. versions by race; this function
unifies all of these tables under one code. So, for example, use \code{P012},
not \code{P012A}.}

\item{geo}{The geographic level to return. One of the machine-readable or
human-readable names listed in the "Details" section of \code{\link[=cens_geo]{cens_geo()}}. Will
return all matching geographies of this level, as filtered by the further
arguments to \code{...}.  For example, setting \code{geo="tract"} is equivalent to
setting \code{tract="all"}.}

\item{...}{Geographies to return, as supported by the Census API. Order
matters here---the first argument will be the geographic level to return
(i.e., it corresponds to the \code{geo} argument) and additional arguments will
filter the results. Use \code{"all"}, \code{"*"}, \code{NA}, or \code{TRUE} to return all units
of a particular geography.  See the examples of \code{\link[=cens_geo]{cens_geo()}} for details.}

\item{check_geo}{If \code{TRUE}, validate the provided geographies against the
available geographies from the relevant Census API.}

\item{drop_total}{Whether to filter out variables which are totals across
another variable. Recommended only after inspection of the underlying
table.}

\item{show_call}{Whether to show the actual call to the Census API. May be
useful for debugging.}

\item{year}{For ACS data, the survey year to get data for.}

\item{survey}{For ACS data, whether to use the one-year or
five-year survey (the default). Make sure to check availability using
\code{\link[=cens_find_acs]{cens_find_acs()}}.}
}
\value{
A tibble of census data in tidy format, with columns
\code{GEOID}, \code{NAME}, \code{variable} (containing the Census variable code),
\code{value} or \code{estiamte}, \code{moe} in the case of ACS tables,
and additional factor columns specific to the table.
}
\description{
Leverages \code{\link[censusapi:getCensus]{censusapi::getCensus()}} to download tables of census data. Tables
are returned in tidy format, with variables given tidy, human-readable names.
}
\examples{
\dontrun{
cens_get_dec("P3", "state")
cens_get_dec(tables_sf1$H2, "state")
cens_get_dec("H2", "county", state="WA", drop_total=TRUE)

cens_get_acs("B09001", county="King", state="WA")
}

}
