% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alluvial_model_response.R
\name{alluvial_model_response_caret}
\alias{alluvial_model_response_caret}
\title{create model response plot for caret models}
\usage{
alluvial_model_response_caret(train, degree = 4, bins = 5,
  bin_labels = c("LL", "ML", "M", "MH", "HH"),
  col_vector_flow = c("#FF0065", "#009850", "#A56F2B", "#005EAA",
  "#710500", "#7B5380", "#9DD1D1"), method = "median",
  params_bin_numeric_pred = list(center = T, transform = T, scale = T),
  pred_train = NULL, stratum_label_size = 3.5, force = F, ...)
}
\arguments{
\item{train}{caret train object}

\item{degree}{integer,  number of top important variables to select. For
plotting more than 4 will result in two many flows and the alluvial plot
will not be very readable, Default: 4}

\item{bins}{integer, number of bins for numeric variables, increasing this
number might result in too many flows, Default: 5}

\item{bin_labels}{labels for the bins from low to high, Default: c("LL", "ML",
"M", "MH", "HH")}

\item{col_vector_flow, }{character vector, defines flow colours, Default:
c('#FF0065','#009850', '#A56F2B', '#005EAA', '#710500')}

\item{method, }{character vector, one of c('median', 'pdp') \describe{
\item{median}{sets variables that are not displayed to median mode, use with
regular predictions} \item{pdp}{partial dependency plot method, for each
observation in the training data the displayed variableas are set to the
indicated values. The predict function is called for each modified
observation and the result is averaged} }. Default: 'median'}

\item{params_bin_numeric_pred}{list, additional parameters passed to
\code{\link[easyalluvial]{manip_bin_numerics}} which is applied to the pred
parameter. Default: list( bins = 5, center = T, transform = T, scale = T)}

\item{pred_train}{numeric vector, base the automated binning of the pred vector on
the distribution of the training predictions. This is useful if marginal
histograms are added to the plot later. Default = NULL}

\item{stratum_label_size}{numeric, Default: 3.5}

\item{force}{logical, force plotting of over 1500 flows, Default: FALSE}

\item{...}{additional parameters passed to
\code{\link[easyalluvial]{alluvial_wide}}}
}
\value{
ggplot2 object
}
\description{
Wraps \code{\link[easyalluvial]{alluvial_model_response}} and
 \code{\link[easyalluvial]{get_data_space}} into one call for caret models.
}
\details{
this model visualisation approach follows the "visualising the model
 in the dataspace" principle as described in Wickham H, Cook D, Hofmann H
 (2015) Visualizing statistical models: Removing the blindfold. Statistical
 Analysis and Data Mining 8(4) <doi:10.1002/sam.11271>
}
\examples{
df = mtcars2[, ! names(mtcars2) \%in\% 'ids' ]

train = caret::train( disp ~ .
                     , df
                     , method = 'rf'
                     , trControl = caret::trainControl( method = 'none' )
                     , importance = TRUE )

alluvial_model_response_caret(train, degree = 3)

# partial dependency plotting method
\dontrun{
alluvial_model_response_caret(train, degree = 3, method = 'pdp')
 }
}
\seealso{
\code{\link[easyalluvial]{alluvial_wide}},
 \code{\link[easyalluvial]{get_data_space}}, \code{\link[caret]{varImp}},
 \code{\link[caret]{extractPrediction}},
 \code{\link[easyalluvial]{get_data_space}},
 \code{\link[easyalluvial]{get_pdp_predictions}}
}
