% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProtectTable.R
\encoding{UTF8}
\name{ProtectTable}
\alias{ProtectTable}
\alias{ProtectTableData}
\title{Easy interface to sdcTable: Table suppression according to a frequency rule.}
\usage{
ProtectTable(
  data,
  dimVar = 1:NCOL(data),
  freqVar = NULL,
  protectZeros = TRUE,
  maxN = 3,
  method = "Gauss",
  findLinked = TRUE,
  total = "Total",
  addName = FALSE,
  sep = "_",
  removeZeros = FALSE,
  dimList = NULL,
  groupVarInd = NULL,
  ind1 = NULL,
  ind2 = NULL,
  rowData = NULL,
  varNames = paste("var", 1:100, sep = ""),
  split = NULL,
  border = sep,
  revBorder = FALSE,
  freqName = "values",
  totalFirst = FALSE,
  numericOrder = TRUE,
  namesAsInput = TRUE,
  orderAsInput = TRUE,
  sortByReversedColumns = FALSE,
  doUnstack = TRUE,
  removeTotal = TRUE,
  singleOutput = NULL,
  suppression = NA,
  outFreq = "freq",
  outSdcStatus = "sdcStatus",
  outSuppressed = "suppressed",
  infoAsFrame = FALSE,
  IncProgress = IncDefault,
  verbose = FALSE,
  ...
)

ProtectTableData(data, ...)
}
\arguments{
\item{data}{data frame}

\item{dimVar}{The main dimensional variables and additional aggregating variables (name or number).}

\item{freqVar}{Variable(s) holding counts or NULL in the case of micro data (name or number).}

\item{protectZeros}{When TRUE empty cells (count=0) is considered sensitive (i.e. same as allowZeros in  \code{\link{primarySuppression}}).}

\item{maxN}{All cells having counts <= maxN are set as primary suppressed.}

\item{method}{Parameter \code{method} in \code{\link{protectTable}}, \code{\link{protect_linked_tables}}
or wrapper methods via \code{\link{PTwrap}}.
\code{Gauss} (default) is an additional method that is not available in sdcTable.
\itemize{
\item \strong{\code{"SIMPLEHEURISTIC"}:} This method is default in protectable.
\item \strong{\code{"SIMPLEHEURISTIC_OLD"}:} As \code{"SIMPLEHEURISTIC"} in sdcTable versions prior to 0.32.
\item \strong{\code{"OPT"}, \code{"HITAS"}, \code{"HYPERCUBE"}:} Other methods in protectable. \code{"HYPERCUBE"} is not possible in cases with two linked tables.
\item \strong{\code{"SimpleSingle"}:}  \code{"SIMPLEHEURISTIC_OLD"} with \code{detectSingletons=TRUE} when \code{protectZeros=FALSE} and
\code{"SIMPLEHEURISTIC_OLD"} with \code{threshold=1} (can be overridden by input) when \code{protectZeros=TRUE}.
\item \strong{\code{"SIMPLEHEURISTICSingle"}:} As \code{"SimpleSingle"} with \code{"SIMPLEHEURISTIC"} instead of \code{"SIMPLEHEURISTIC_OLD"}.
\item \strong{\code{"Simple"}:} \code{"SIMPLEHEURISTIC_OLD"} with \code{detectSingletons=FALSE}.
\item \strong{\code{"Gauss"}:} \code{\link{GaussSuppression}} is called with parameters \code{x}, \code{candidates}, \code{primary} and \code{singleton} automatically generated.
Other parameters (\code{singletonMethod}, \code{printInc}) can be specified.
}

Alternatively this parameter can be a named list specifying parameters for running tau-argus (see details).
See \code{\link{PTwrap}} for other (experimental) wrapper methods (see details).}

\item{findLinked}{When TRUE, the function may find two linked tables and run protect_linked_tables.}

\item{total}{String used to name totals.}

\item{addName}{When TRUE the variable name is added to the level names, except for variables with most levels.}

\item{sep}{A character string to separate when addName apply and when creating variable names.}

\item{removeZeros}{When TRUE, rows with zero count will be removed from the data within the algorithm.}

\item{dimList}{By default, hierarchies will be automatically found from data (see \code{\link{FindDimLists}}).
With non-NULL dimList, these will be changed.
In practice this is done by the function \code{\link{ReplaceDimList}}.}

\item{groupVarInd}{Possible manual specification of list defining the hierarchical
variable groups. When NULL (default) this information will be found automatically
by \code{\link{FindTableGroup}}.}

\item{ind1}{Coding of table 1 as indices referring to elements of groupVarInd. This information
will be found automatically
by \code{\link{FindTableGroup}} when groupVarInd=NULL.}

\item{ind2}{Coding of table 2 as indices referring to elements of groupVarInd (as ind1 above).}

\item{rowData}{Input to \code{\link{Stack}} used to generate extra dimVar variables when stacking in cases with several
freqvar variables. When NULL rowData will be created automatically by \code{\link{AutoSplit}} using varNames (see below)
and the the freqvar names as input.}

\item{varNames}{The names of the extra dimVar variable(s) made when stacking in cases with several
freqvar variables. When length(varNames)>1 several variables may be found by \code{\link{AutoSplit}}.}

\item{split}{Parameter to \code{\link{AutoSplit}} - see varNames and rowData above.
When NULL (default), automatic splitting without needing a split string.}

\item{border}{Parameter to \code{\link{AutoSplit}} - see varNames and rowData above.}

\item{revBorder}{Parameter to \code{\link{AutoSplit}} - see varNames and rowData above..}

\item{freqName}{Input to \code{\link{Stack}}. The name of the new freqvar variable obtained when stacking in cases with several
input freqvar variables.}

\item{totalFirst}{Parameter controlling how output is sorted.}

\item{numericOrder}{Parameter controlling how output is sorted.
Output is character but sorting can be based on the numeric input variables.}

\item{namesAsInput}{When TRUE those output variables (created by unstacking) that correspond to input will be named as input.}

\item{orderAsInput}{When TRUE output corresponding to input will be ordered as input and kept together as one block.}

\item{sortByReversedColumns}{When TRUE output will be sorted by variables in opposite order.}

\item{doUnstack}{When FALSE output will not be unstacked (in cases with sever input freqvar variables)}

\item{removeTotal}{When TRUE the total string (see total above) will be removed from the names of output variables
created by unstacking (in cases with sever input freqvar variables).}

\item{singleOutput}{When TRUE output will be in as single data set. Default is FALSE for unstacked data
(in cases with sever input freqvar variables) and otherwise TRUE.}

\item{suppression}{Value used for suppressed elements in suppressed output data. Default is NA.}

\item{outFreq}{String used to name output variable(s)}

\item{outSdcStatus}{String used to name output variable(s)}

\item{outSuppressed}{String used to name output variable(s)}

\item{infoAsFrame}{When TRUE output element info is a data frame (useful in Shiny).}

\item{IncProgress}{A function to report progress (incProgress in Shiny). Set equal to NULL to turn it off.}

\item{verbose}{Parameter sent to \code{\link{protectTable}}, \code{\link{protect_linked_tables}} or \code{\link{runArgusBatchFile}}.}

\item{...}{Further parameters sent to \code{\link{protectTable}} (possibly via \code{\link{protect_linked_tables}})
such as solve_attackerprobs and timeLimit.
Parameters to  \code{\link{GaussSuppression}}, \code{\link{createArgusInput}} and \code{\link{PTwrap}} is also possible (see details).}
}
\value{
When singleOutput=TRUE output is a list of two elements.
\itemize{
\item \strong{\code{info}:} Information as a single column character matrix. This is information about the extra
dimVar variables created when stacking, information about the identified (linked)
table(s) and summary output from sdcTable.
With \code{method="Gauss"}, a sdcTable function is run with \code{maxN=0} to create a template for the real output.
Some of the summary info is therefore misleading in this case.
\item \strong{\code{data}:} A data frame where variables are named according to outFreq,
outSdcStatus and outSuppressed.
When singleOutput=FALSE output element data is replaced by three elements and these are named
according to outFreq, outSdcStatus and outSuppressed.
}
}
\description{
\code{\link{GaussSuppression}}, \code{\link{protectTable}} or  \code{\link{protect_linked_tables}}
is run with a data set as the only required input. One (stacked) or several (unstacked) input variables can hold cell counts.
\code{ProtectTableData} is a tidy wrapper function, which returns a single data frame instead of a list (\code{info} omitted).
}
\details{
One or two tables are identified automatically and subjected to cell suppression
by \code{\link{protectTable}} (single table) or \code{\link{protect_linked_tables}} (two linked tables).
The tables can alternatively be specified manually by groupVarInd, ind1 and ind2.
The output will be on a form similiar to input depending on whether freqVar is a single variable or not.
The status of the cells are
coded as  "u" (primary suppressed), "x" (secondary suppression), and "s" (can be published).
This is taken directly from the output from sdcTable. In cases with two linked tables "u" or "x"
for common cells are based on output from the first table.
\itemize{
\item \strong{To run tau-argus} specify \code{method} as a named list containing the
parameter \code{exe} for \code{\link{runArgusBatchFile}} and other parameters for
\code{\link{createArgusInput}}.
\itemize{
\item One may specify:
\code{method = list(exe="C:/Tau/TauArgus.exe", typ="tabular", path= getwd(),}
\code{solver= "FREE", method= "OPT")}
However these values of "exe", "path" and "solver" and "method" are set by default so in this case
using "\code{method = list(typ="tabular", method= "OPT")}" is equivalent.
\item If \code{typ="microdata"} is specified. Necessary transformation to microdata will be made.
}
\item \strong{Wrapper methods (partly experimental):}
In the function \code{\link{PTwrap}} several additional methods are defined.
If input to ProtectTable() is one of these methods ProtectTable() will
be run via PTwrap(). So making explicit call to PTwrap() is not needed.
\item \strong{Singleton and zeros:} The parameter detectSingletons was included in protecttable to handle the so-called
singleton problem that appers  when \code{protectZeros=FALSE}.
Not all problems were solved and the parameter threshold has been introduced later. The value of threshold
needed depends on the number of singletons in one group. It seems that \code{threshold=3} is equivalent to \code{detectSingletons=TRUE}.
When \code{protectZeros=TRUE} the related “zero problem” occurs. This problem is solved by \code{threshold=1}.
\item \strong{NOTE:} The use of numVarInd, weightInd and sampWeightInd in sdcTable is not implemented. This also limit possible
input to  tau-argus.
}
}
\note{
ProtectTable makes a call to the function \code{\link{ProtectTable1}}.
}
\examples{
 # ==== Example 1 , 8 regions ====
 z1 <- EasyData("z1")        
 ProtectTable(z1,1:2, 3)
 ProtectTableData(z1,1:2, 3)
 ProtectTable(z1, c("region","hovedint"), "ant") # Input by name 
 # --- Unstacked input data ---
 z1w = EasyData("z1w") 
 ProtectTable(z1w, 1, 2:5)
 ProtectTableData(z1w, 1, 2:5)
 ProtectTable(z1w, 1, 2:5, varName="hovedint") 
 ProtectTable(z1w, 1, 2:5, method="HITAS")
 ProtectTable(z1w, 1, 2:5, totalFirst = TRUE, method ="Simple")
 
 # ==== Example 2 , 11 regions ====
 z2 <- EasyData("z2") 
 ProtectTable(z2,c(1,3,4), 5) # With region-variable kostragr
 # --- Unstacked input data ---
 z2w <- EasyData("z2w") 
 ProtectTable(z2w, 1:2, 4:7) # With region-variable fylke
 ProtectTable(z2w, 1:3, 4:7) # Two linked tables
 
 \dontrun{
 # ==== Example 3 , 36 regions ====
 z3 <- EasyData("z3")   
 ProtectTable(z3, c(1,4,5), 7)                               # Three dimensions. No subtotals    
 ProtectTable(z3, 1:6, 7)                                    # Two linked tables  
 # --- Unstacked input data with coded column names 
 z3w <- EasyData("z3w")
 ProtectTable(z3w,1:3,4:15, varName="g12")                   # coding not used when single varName
 ProtectTable(z3w,1:3,4:15, varName=c("hovedint","mnd"))     # Two variables found automatically 
 ProtectTable(z3w,1:3,4:15, varName=c("hovedint","mnd"),
               removeTotal=FALSE)                            # Keep "Total" in variable names 
 # --- Unstacked input data with three level column name coding
 z3wb <- EasyData("z3wb")  
 ProtectTable(z3wb,1:3,4:15,varName=c("hovedint","mnd","mnd2")) # Two variables found automatically
 ProtectTable(z3wb,1:3,4:15,varName=c("hovedint","mnd","mnd2"), 
             split="_")                                         # Three variables when splitting
 ProtectTable(z3wb,1:3,4:15,varName=c("hovedint","mnd","mnd2"),
               split="_",namesAsInput=FALSE,orderAsInput=FALSE) # Alternative ouput format
               
 # ====  Examples Tau-Argus ====              
 exeArgus <- "C:/TauArgus4.1.4/TauArgus.exe" # Change to TauArgus.exe-path in your computer
 pathArgus <- "C:/Users/nnn/Documents"       # Change to an existing folder 
 z1 = EasyData("z1") 
 ProtectTable(z1,1:2,3,method=list(exe=exeArgus, path=pathArgus, typ="tabular", method="OPT")) 
 ProtectTable(z1,1:2,3,method=list(exe=exeArgus, path=pathArgus, typ="tabular", method="MOD")) 
 ProtectTable(z1,1:2,3,method=list(exe=exeArgus, path=pathArgus, typ="tabular", method="GH"))
  ProtectTable(z1,1:2,3,maxN=-1,
   method=list(path=pathArgus, exe=exeArgus, method="OPT",
         primSuppRules= list(list(type="freq", n=4, rg=20))))
 z3 <- EasyData("z3")
 ProtectTable(z3,c(1:2,4,5),7,maxN=-1,
   method=list(path=pathArgus, exe=exeArgus, method="OPT",
         primSuppRules=list(list(type="freq", n=4, rg=20))))
         
               
# ==== Examples with parameter dimList  ====
z2 <- EasyData("z2")
dList <- FindDimLists(z2[-5])
ProtectTable(z2[, c(1,4,5)], 1:2, 3, dimList = dList[c(1,3)])
ProtectTable(z2[, c(1,4,5)], 1:2, 3, dimList = dList[2])
ProtectTable(z2[, c(1,4,5)], 1:2, 3, dimList = DimList2Hrc(dList[c(2,3)]))
}
              
}
\seealso{
See also the vignettes.
}
