% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{et_calculate}
\alias{et_calculate}
\title{et_calculate}
\usage{
et_calculate(astro, astro_der, k_mat, phases, delta, deltar, c0, s0, c1,
  s1, c2, s2, dgk, jcof, j2000, o1, resonance, index, astro_update,
  update_coef, predict)
}
\arguments{
\item{astro}{matrix astronomical parameters}

\item{astro_der}{matrix derivative of astronomical parameters}

\item{k_mat}{matrix tidal catalog values}

\item{phases}{vector phases}

\item{delta}{vector body}

\item{deltar}{double gravimentric factor}

\item{c0}{vector tidal catalog values}

\item{s0}{vector tidal catalog values}

\item{c1}{vector tidal catalog values}

\item{s1}{vector tidal catalog values}

\item{c2}{vector tidal catalog values}

\item{s2}{vector tidal catalog values}

\item{dgk}{vector geodetic coefficients}

\item{jcof}{vector wave index}

\item{j2000}{double Julian date}

\item{o1}{double frequency}

\item{resonance}{double frequency}

\item{index}{vector wave group index}

\item{astro_update}{how often to recalculate astronomical parameters}

\item{update_coef}{time for approx}

\item{predict}{predict or analyze}
}
\value{
synthetic gravity
}
\description{
Parallel calculation of tidal potential for a single time and multiple waves.  Code adapted from ETERNA.
}
\references{
Wenzel, H.-G. (1996): The nanogal software: Earth tide data
processing package ETERNA 3.3. Bulletin d'Informations
Marees Terrestres vol. 124, 9425-9439, Bruxelles 1996.
}
\author{
Jonathan Kennel, \email{jkennel@uoguelph.ca}
}
