% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ea_funcs.R
\name{eadrm.ci}
\alias{eadrm.ci}
\title{Computes confidence intervals for an eadrm model fit}
\usage{
eadrm.ci(obs, xvals, model = "h4", ..., B = 1000)
}
\arguments{
\item{obs}{A vector of response values (y-values).}

\item{xvals}{A vector of doses (x-values).}

\item{model}{Type of dose-response model to fit. Possible values
include "h3", "h4", and "h5" (correspoding to 3-paramater,
4-parameter, and 5-paramter log-logistic models, respectively) and
"e" (corresponding to an exponential model). Defaults to "h4".}

\item{...}{Additional parameters for the eadrm function.}

\item{B}{Number of replicate models to fit. Defaults to 1000.}
}
\value{
A list containing the following elements:
\describe{
\item{med.est:}{A vector of the median values of the coefficients
across the B iterations}
\item{l95.est,u95est:}{Vectors of the lower/upper 95\% confidence
bounds for the coefficients across the B iterations}
\item{replicate.mat:}{A p x B matrix, where p is the number of
coefficients in the model. Each column of B corresponds to the
coefficients for one fitted model.}
}
}
\description{
Calculates confidence intervals for an eadrm model fit by
repeatedly fitting the model to the same data set and examining
the distribution of the coefficients.
}
\section{Details}{

This function calls the \code{\link{eadrm}} function B times with
the same parameters and records the model coefficients for each
iteration of the model. Confidence intervals for the coefficients
are calculated by examining the quantiles of the distribution
of the coefficients over the B iterations. A matrix of the
coefficients for each iteration is also calculated. This matrix
can be used to compute confidence intervals for predicted values
and estimates of EC50.
}

\examples{
\donttest{ea.ci <- eadrm.ci(CarboA$y, CarboA$x)}
}
\seealso{
\code{\link{eadrm}}, \code{\link{predict.eadrm}},
\code{\link{calc.ec}}, \code{\link{calc.ed}}
}
