% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation_metrics.R
\name{evaluation_metrics}
\alias{evaluation_metrics}
\title{Calculate SDM evaluation metrics}
\usage{
evaluation_metrics(x, x.idx, y, y.idx, count.flag = FALSE)
}
\arguments{
\item{x}{object of class sf; SDM predictions}

\item{x.idx}{name or index of column in \code{x} with prediction values}

\item{y}{object of class sf; validation data}

\item{y.idx}{name or index of column in \code{y} with validation data.
This validation data column must have at least two unique values, e.g. 0 and 1}

\item{count.flag}{logical; \code{TRUE} indicates that the data in column \code{y.idx} is count data,
while \code{FALSE} indicates that the data is presence/absence.
See details for differences in data processing based on this flag.}
}
\value{
A numeric vector with AUC, TSS and RMSE values, respectively.
  If \code{count.flag == FALSE}, the RMSE value will be \code{NA}
}
\description{
Calculate AUC, TSS, and RMSE for given density predictions and validation data
}
\details{
If \code{count.flag == TRUE}, then \code{eSDM::model_abundance(x, x.idx, FALSE)} will be run
  to calculate predicted abundance and thus calculate RMSE.
  Note that this assumes the data in column \code{x.idx} of \code{x} are density values.

  If \code{count.flag == FALSE}, then all of the values in column \code{y.idx} of \code{y} must be \code{0} or \code{1}.

  All rows of \code{x} with a value of \code{NA} in column \code{x.idx} and
  all rows of \code{y} with a value of \code{NA} in column \code{y.idx} are removed before calculating metrics
}
\examples{
evaluation_metrics(preds.1, 1, validation.data, "sight")

evaluation_metrics(preds.1, "Density", validation.data, "count", TRUE)

}
