% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext.R
\name{heatcv}
\alias{heatcv}
\title{Plot a heatmap of the prediction performance statistic as a function of lambda and alpha combinations}
\usage{
heatcv(psp, bias = 0.1, by.rownames = 1, by.colnames = 1,
  paletcol = c("cyan", "blue", "black", "red", "orange"),
  paletncol = 1000, xlab = "Alpha-dependent log-Lambda",
  ylab = "Alpha", main = "", plot.opt = TRUE, plot.1sd = FALSE,
  ...)
}
\arguments{
\item{psp}{An S4-class PSP-object to plot, as built using the ePCR-package}

\item{bias}{Bias in color palette (skews it to favor distinguishing high values better by default)}

\item{by.rownames}{Show every n:th row name (helps for dense axis labels)}

\item{by.colnames}{Show every n:th column name (helps for dense axis labels)}

\item{paletcol}{Names for colours to include in the heatmap palette}

\item{paletncol}{Number of colours on the color key}

\item{xlab}{Label for the x-axis (typically log-lambda penalization parameter)}

\item{ylab}{Label for the y-axis (typically alpha-value indicating LASSO, elastic net or ridge regression)}

\item{main}{Main label on top of the heatmap}

\item{plot.opt}{Should the best (highest) performance statistic be indicated as a large dot on the heatmap}

\item{plot.1sd}{Should boundaries of the optimal performance statistic area be outlined as within 1 standard deviation of the optimal spot (note: experimental). This attempts to mimic the 1sd-optimum suggested in the glmnet-package for cross-validation for a constant alpha parameter but for 2 dimensions.}

\item{...}{additional parameters passed on to the hmap-function of hamlet-package}
}
\description{
This function plots a heatmap of cross-validation results by varying the penalization/regularization parameter (lambda, x-axis), together with the corresponding L1/L2 norm parameter alpha (i.e. LASSO, elastic net, ridge regression). The optimal spot in the parameter grid gives insight into the behavior of the regularization in respect to the norms, but note that the lambda-parameter on x-axis is not constant given a conditional alpha-parameter; rather it is a suitable vector chosen by the glmnet-package.
}
\note{
The heatmap plotting is compatible with the default plot-region in a R graphic canvas. The function hmap from the same author's hmap-package can be highly customized to fit more specific needs.
}
\examples{
data(ePCRmodels)
par(mfrow=c(1,3))
heatcv(DREAM@PSPs[[1]], main=DREAM@PSPs[[1]]@description, by.rownames=10, by.colnames=10)
heatcv(DREAM@PSPs[[2]], main=DREAM@PSPs[[2]]@description, by.rownames=10, by.colnames=10)
heatcv(DREAM@PSPs[[3]], main=DREAM@PSPs[[3]]@description, by.rownames=10, by.colnames=10)
}
\author{
Teemu Daniel Laajala \email{teelaa@utu.fi}
}
