// Generated by rstantools.  Do not edit by hand.

/*
    eDNAjoint is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    eDNAjoint is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with eDNAjoint.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_traditional_catchability_gamma_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 49> locations_array__ =
  {" (found before start of program)",
  " (in 'traditional_catchability_gamma', line 10, column 4 to column 36)",
  " (in 'traditional_catchability_gamma', line 11, column 4 to column 39)",
  " (in 'traditional_catchability_gamma', line 12, column 4 to column 44)",
  " (in 'traditional_catchability_gamma', line 15, column 4 to column 28)",
  " (in 'traditional_catchability_gamma', line 16, column 4 to column 35)",
  " (in 'traditional_catchability_gamma', line 32, column 2 to column 20)",
  " (in 'traditional_catchability_gamma', line 33, column 2 to column 20)",
  " (in 'traditional_catchability_gamma', line 34, column 2 to column 28)",
  " (in 'traditional_catchability_gamma', line 18, column 6 to column 48)",
  " (in 'traditional_catchability_gamma', line 17, column 17 to line 19, column 5)",
  " (in 'traditional_catchability_gamma', line 17, column 4 to line 19, column 5)",
  " (in 'traditional_catchability_gamma', line 21, column 6 to column 42)",
  " (in 'traditional_catchability_gamma', line 20, column 17 to line 22, column 5)",
  " (in 'traditional_catchability_gamma', line 20, column 4 to line 22, column 5)",
  " (in 'traditional_catchability_gamma', line 35, column 2 to column 18)",
  " (in 'traditional_catchability_gamma', line 37, column 4 to column 31)",
  " (in 'traditional_catchability_gamma', line 36, column 18 to line 38, column 3)",
  " (in 'traditional_catchability_gamma', line 36, column 2 to line 38, column 3)",
  " (in 'traditional_catchability_gamma', line 40, column 4 to column 38)",
  " (in 'traditional_catchability_gamma', line 39, column 21 to line 41, column 3)",
  " (in 'traditional_catchability_gamma', line 39, column 2 to line 41, column 3)",
  " (in 'traditional_catchability_gamma', line 43, column 10 to column 80)",
  " (in 'traditional_catchability_gamma', line 42, column 17 to line 44, column 7)",
  " (in 'traditional_catchability_gamma', line 42, column 4 to line 44, column 7)",
  " (in 'traditional_catchability_gamma', line 26, column 6 to column 57)",
  " (in 'traditional_catchability_gamma', line 25, column 17 to line 27, column 5)",
  " (in 'traditional_catchability_gamma', line 25, column 4 to line 27, column 5)",
  " (in 'traditional_catchability_gamma', line 28, column 4 to column 28)",
  " (in 'traditional_catchability_gamma', line 29, column 4 to column 29)",
  " (in 'traditional_catchability_gamma', line 2, column 4 to column 19)",
  " (in 'traditional_catchability_gamma', line 3, column 10 to column 11)",
  " (in 'traditional_catchability_gamma', line 3, column 4 to column 28)",
  " (in 'traditional_catchability_gamma', line 4, column 4 to column 22)",
  " (in 'traditional_catchability_gamma', line 5, column 10 to column 11)",
  " (in 'traditional_catchability_gamma', line 5, column 4 to column 29)",
  " (in 'traditional_catchability_gamma', line 6, column 4 to column 25)",
  " (in 'traditional_catchability_gamma', line 7, column 11 to column 12)",
  " (in 'traditional_catchability_gamma', line 7, column 13 to column 20)",
  " (in 'traditional_catchability_gamma', line 7, column 4 to column 26)",
  " (in 'traditional_catchability_gamma', line 10, column 10 to column 14)",
  " (in 'traditional_catchability_gamma', line 11, column 10 to column 14)",
  " (in 'traditional_catchability_gamma', line 12, column 27 to column 34)",
  " (in 'traditional_catchability_gamma', line 15, column 20 to column 21)",
  " (in 'traditional_catchability_gamma', line 16, column 10 to column 11)",
  " (in 'traditional_catchability_gamma', line 32, column 9 to column 16)",
  " (in 'traditional_catchability_gamma', line 33, column 9 to column 10)",
  " (in 'traditional_catchability_gamma', line 34, column 9 to column 13)",
  " (in 'traditional_catchability_gamma', line 34, column 14 to column 23)"};
#include <stan_meta_header.hpp>
class model_traditional_catchability_gamma final : public model_base_crtp<model_traditional_catchability_gamma> {
private:
  int C;
  std::vector<int> R;
  int Nloc;
  std::vector<double> E;
  int nparams;
  Eigen::Matrix<double,-1,-1> mat_data__;
  int mu_2dim__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> mat{nullptr, 0, 0};
public:
  ~model_traditional_catchability_gamma() {}
  model_traditional_catchability_gamma(stan::io::var_context& context__,
                                       unsigned int random_seed__ = 0,
                                       std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_traditional_catchability_gamma_namespace::model_traditional_catchability_gamma";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 30;
      context__.validate_dims("data initialization", "C", "int",
        std::vector<size_t>{});
      C = std::numeric_limits<int>::min();
      current_statement__ = 30;
      C = context__.vals_i("C")[(1 - 1)];
      current_statement__ = 30;
      stan::math::check_greater_or_equal(function__, "C", C, 1);
      current_statement__ = 31;
      stan::math::validate_non_negative_index("R", "C", C);
      current_statement__ = 32;
      context__.validate_dims("data initialization", "R", "int",
        std::vector<size_t>{static_cast<size_t>(C)});
      R = std::vector<int>(C, std::numeric_limits<int>::min());
      current_statement__ = 32;
      R = context__.vals_i("R");
      current_statement__ = 32;
      stan::math::check_greater_or_equal(function__, "R", R, 1);
      current_statement__ = 33;
      context__.validate_dims("data initialization", "Nloc", "int",
        std::vector<size_t>{});
      Nloc = std::numeric_limits<int>::min();
      current_statement__ = 33;
      Nloc = context__.vals_i("Nloc")[(1 - 1)];
      current_statement__ = 33;
      stan::math::check_greater_or_equal(function__, "Nloc", Nloc, 1);
      current_statement__ = 34;
      stan::math::validate_non_negative_index("E", "C", C);
      current_statement__ = 35;
      context__.validate_dims("data initialization", "E", "double",
        std::vector<size_t>{static_cast<size_t>(C)});
      E = std::vector<double>(C, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 35;
      E = context__.vals_r("E");
      current_statement__ = 35;
      stan::math::check_greater_or_equal(function__, "E", E, 0);
      current_statement__ = 36;
      context__.validate_dims("data initialization", "nparams", "int",
        std::vector<size_t>{});
      nparams = std::numeric_limits<int>::min();
      current_statement__ = 36;
      nparams = context__.vals_i("nparams")[(1 - 1)];
      current_statement__ = 36;
      stan::math::check_greater_or_equal(function__, "nparams", nparams, 0);
      current_statement__ = 37;
      stan::math::validate_non_negative_index("mat", "C", C);
      current_statement__ = 38;
      stan::math::validate_non_negative_index("mat", "nparams", nparams);
      current_statement__ = 39;
      context__.validate_dims("data initialization", "mat", "double",
        std::vector<size_t>{static_cast<size_t>(C),
          static_cast<size_t>(nparams)});
      mat_data__ = Eigen::Matrix<double,-1,-1>::Constant(C, nparams,
                     std::numeric_limits<double>::quiet_NaN());
      new (&mat) Eigen::Map<Eigen::Matrix<double,-1,-1>>(mat_data__.data(),
        C, nparams);
      {
        std::vector<local_scalar_t__> mat_flat__;
        current_statement__ = 39;
        mat_flat__ = context__.vals_r("mat");
        current_statement__ = 39;
        pos__ = 1;
        current_statement__ = 39;
        for (int sym1__ = 1; sym1__ <= nparams; ++sym1__) {
          current_statement__ = 39;
          for (int sym2__ = 1; sym2__ <= C; ++sym2__) {
            current_statement__ = 39;
            stan::model::assign(mat, mat_flat__[(pos__ - 1)],
              "assigning variable mat", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 39;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 40;
      stan::math::validate_non_negative_index("alpha", "Nloc", Nloc);
      current_statement__ = 41;
      stan::math::validate_non_negative_index("beta", "Nloc", Nloc);
      current_statement__ = 42;
      stan::math::validate_non_negative_index("q_trans", "nparams", nparams);
      current_statement__ = 43;
      stan::math::validate_non_negative_index("coef", "C", C);
      current_statement__ = 44;
      stan::math::validate_non_negative_index("E_trans", "C", C);
      current_statement__ = 45;
      stan::math::validate_non_negative_index("q", "nparams", nparams);
      current_statement__ = 46;
      stan::math::validate_non_negative_index("log_lik", "C", C);
      current_statement__ = 47;
      stan::math::validate_non_negative_index("mu", "Nloc", Nloc);
      current_statement__ = 48;
      mu_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 48;
      mu_2dim__ = (nparams + 1);
      current_statement__ = 48;
      stan::math::validate_non_negative_index("mu", "nparams + 1", mu_2dim__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = Nloc + Nloc + nparams;
  }
  inline std::string model_name() const final {
    return "model_traditional_catchability_gamma";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_traditional_catchability_gamma_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<local_scalar_t__> alpha =
        std::vector<local_scalar_t__>(Nloc, DUMMY_VAR__);
      current_statement__ = 1;
      alpha = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
                jacobian__>(0, lp__, Nloc);
      std::vector<local_scalar_t__> beta =
        std::vector<local_scalar_t__>(Nloc, DUMMY_VAR__);
      current_statement__ = 2;
      beta = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
               jacobian__>(0.01, lp__, Nloc);
      Eigen::Matrix<local_scalar_t__,-1,1> q_trans =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nparams, DUMMY_VAR__);
      current_statement__ = 3;
      q_trans = in__.template read_constrain_lb<
                  Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(-0.99999,
                  lp__, nparams);
      Eigen::Matrix<local_scalar_t__,-1,1> coef =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(C, DUMMY_VAR__);
      std::vector<local_scalar_t__> E_trans =
        std::vector<local_scalar_t__>(C, DUMMY_VAR__);
      current_statement__ = 11;
      for (int i = 1; i <= C; ++i) {
        current_statement__ = 9;
        stan::model::assign(coef, (1 +
          stan::math::dot_product(
            stan::model::rvalue(mat, "mat", stan::model::index_uni(i)),
            q_trans)), "assigning variable coef", stan::model::index_uni(i));
      }
      current_statement__ = 14;
      for (int j = 1; j <= C; ++j) {
        current_statement__ = 12;
        stan::model::assign(E_trans,
          (stan::model::rvalue(E, "E", stan::model::index_uni(j)) +
          0.0000000000001), "assigning variable E_trans",
          stan::model::index_uni(j));
      }
      current_statement__ = 4;
      stan::math::check_greater_or_equal(function__, "coef", coef, 0);
      current_statement__ = 5;
      stan::math::check_greater_or_equal(function__, "E_trans", E_trans, 0);
      {
        current_statement__ = 27;
        for (int j = 1; j <= C; ++j) {
          current_statement__ = 25;
          lp_accum__.add(stan::math::gamma_lpdf<propto__>(
                           stan::model::rvalue(E_trans, "E_trans",
                             stan::model::index_uni(j)),
                           (stan::model::rvalue(coef, "coef",
                              stan::model::index_uni(j)) *
                           stan::model::rvalue(alpha, "alpha",
                             stan::model::index_uni(
                               stan::model::rvalue(R, "R",
                                 stan::model::index_uni(j))))),
                           stan::model::rvalue(beta, "beta",
                             stan::model::index_uni(
                               stan::model::rvalue(R, "R",
                                 stan::model::index_uni(j))))));
        }
        current_statement__ = 28;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(beta, 0.25, 0.25));
        current_statement__ = 29;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(alpha, 0.01, 0.01));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_traditional_catchability_gamma_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<double> alpha =
        std::vector<double>(Nloc, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      alpha = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
                jacobian__>(0, lp__, Nloc);
      std::vector<double> beta =
        std::vector<double>(Nloc, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      beta = in__.template read_constrain_lb<std::vector<local_scalar_t__>,
               jacobian__>(0.01, lp__, Nloc);
      Eigen::Matrix<double,-1,1> q_trans =
        Eigen::Matrix<double,-1,1>::Constant(nparams,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      q_trans = in__.template read_constrain_lb<
                  Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(-0.99999,
                  lp__, nparams);
      Eigen::Matrix<double,-1,1> coef =
        Eigen::Matrix<double,-1,1>::Constant(C,
          std::numeric_limits<double>::quiet_NaN());
      std::vector<double> E_trans =
        std::vector<double>(C, std::numeric_limits<double>::quiet_NaN());
      out__.write(alpha);
      out__.write(beta);
      out__.write(q_trans);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 11;
      for (int i = 1; i <= C; ++i) {
        current_statement__ = 9;
        stan::model::assign(coef, (1 +
          stan::math::dot_product(
            stan::model::rvalue(mat, "mat", stan::model::index_uni(i)),
            q_trans)), "assigning variable coef", stan::model::index_uni(i));
      }
      current_statement__ = 14;
      for (int j = 1; j <= C; ++j) {
        current_statement__ = 12;
        stan::model::assign(E_trans,
          (stan::model::rvalue(E, "E", stan::model::index_uni(j)) +
          0.0000000000001), "assigning variable E_trans",
          stan::model::index_uni(j));
      }
      current_statement__ = 4;
      stan::math::check_greater_or_equal(function__, "coef", coef, 0);
      current_statement__ = 5;
      stan::math::check_greater_or_equal(function__, "E_trans", E_trans, 0);
      if (emit_transformed_parameters__) {
        out__.write(coef);
        out__.write(E_trans);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> q =
        Eigen::Matrix<double,-1,1>::Constant(nparams,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(C,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,-1> mu =
        Eigen::Matrix<double,-1,-1>::Constant(Nloc, mu_2dim__,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 15;
      stan::model::assign(q, stan::math::add(q_trans, 1),
        "assigning variable q");
      current_statement__ = 18;
      for (int j = 1; j <= Nloc; ++j) {
        current_statement__ = 16;
        stan::model::assign(mu,
          (stan::model::rvalue(alpha, "alpha", stan::model::index_uni(j)) /
          stan::model::rvalue(beta, "beta", stan::model::index_uni(j))),
          "assigning variable mu", stan::model::index_uni(j),
          stan::model::index_uni(1));
      }
      current_statement__ = 21;
      for (int i = 1; i <= nparams; ++i) {
        current_statement__ = 19;
        stan::model::assign(mu,
          stan::math::multiply(
            stan::math::to_vector(
              stan::model::deep_copy(
                stan::model::rvalue(mu, "mu", stan::model::index_omni(),
                  stan::model::index_uni(1)))),
            stan::model::rvalue(q, "q", stan::model::index_uni(i))),
          "assigning variable mu", stan::model::index_omni(),
          stan::model::index_uni((i + 1)));
      }
      current_statement__ = 24;
      for (int j = 1; j <= C; ++j) {
        current_statement__ = 22;
        stan::model::assign(log_lik,
          stan::math::gamma_lpdf<false>(
            stan::model::rvalue(E_trans, "E_trans", stan::model::index_uni(j)),
            (stan::model::rvalue(coef, "coef", stan::model::index_uni(j)) *
            stan::model::rvalue(alpha, "alpha",
              stan::model::index_uni(
                stan::model::rvalue(R, "R", stan::model::index_uni(j))))),
            stan::model::rvalue(beta, "beta",
              stan::model::index_uni(
                stan::model::rvalue(R, "R", stan::model::index_uni(j))))),
          "assigning variable log_lik", stan::model::index_uni(j));
      }
      out__.write(q);
      out__.write(log_lik);
      out__.write(mu);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> alpha =
        std::vector<local_scalar_t__>(Nloc, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(alpha,
        in__.read<std::vector<local_scalar_t__>>(Nloc),
        "assigning variable alpha");
      out__.write_free_lb(0, alpha);
      std::vector<local_scalar_t__> beta =
        std::vector<local_scalar_t__>(Nloc, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(beta,
        in__.read<std::vector<local_scalar_t__>>(Nloc),
        "assigning variable beta");
      out__.write_free_lb(0.01, beta);
      Eigen::Matrix<local_scalar_t__,-1,1> q_trans =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nparams, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(q_trans,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(nparams),
        "assigning variable q_trans");
      out__.write_free_lb(-0.99999, q_trans);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "alpha", "double",
        std::vector<size_t>{static_cast<size_t>(Nloc)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{static_cast<size_t>(Nloc)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "q_trans",
        "double", std::vector<size_t>{static_cast<size_t>(nparams)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> alpha =
        std::vector<local_scalar_t__>(Nloc, DUMMY_VAR__);
      current_statement__ = 1;
      alpha = context__.vals_r("alpha");
      out__.write_free_lb(0, alpha);
      std::vector<local_scalar_t__> beta =
        std::vector<local_scalar_t__>(Nloc, DUMMY_VAR__);
      current_statement__ = 2;
      beta = context__.vals_r("beta");
      out__.write_free_lb(0.01, beta);
      Eigen::Matrix<local_scalar_t__,-1,1> q_trans =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nparams, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> q_trans_flat__;
        current_statement__ = 3;
        q_trans_flat__ = context__.vals_r("q_trans");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= nparams; ++sym1__) {
          current_statement__ = 3;
          stan::model::assign(q_trans, q_trans_flat__[(pos__ - 1)],
            "assigning variable q_trans", stan::model::index_uni(sym1__));
          current_statement__ = 3;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(-0.99999, q_trans);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"alpha", "beta", "q_trans"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"coef", "E_trans"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"q", "log_lik", "mu"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    Nloc)},
                std::vector<size_t>{static_cast<size_t>(Nloc)},
                std::vector<size_t>{static_cast<size_t>(nparams)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(C)},
             std::vector<size_t>{static_cast<size_t>(C)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(nparams)},
             std::vector<size_t>{static_cast<size_t>(C)},
             std::vector<size_t>{static_cast<size_t>(Nloc),
               static_cast<size_t>(mu_2dim__)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= Nloc; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= Nloc; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= nparams; ++sym1__) {
      param_names__.emplace_back(std::string() + "q_trans" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        param_names__.emplace_back(std::string() + "coef" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        param_names__.emplace_back(std::string() + "E_trans" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nparams; ++sym1__) {
        param_names__.emplace_back(std::string() + "q" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= mu_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= Nloc; ++sym2__) {
          param_names__.emplace_back(std::string() + "mu" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= Nloc; ++sym1__) {
      param_names__.emplace_back(std::string() + "alpha" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= Nloc; ++sym1__) {
      param_names__.emplace_back(std::string() + "beta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= nparams; ++sym1__) {
      param_names__.emplace_back(std::string() + "q_trans" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        param_names__.emplace_back(std::string() + "coef" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        param_names__.emplace_back(std::string() + "E_trans" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nparams; ++sym1__) {
        param_names__.emplace_back(std::string() + "q" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= mu_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= Nloc; ++sym2__) {
          param_names__.emplace_back(std::string() + "mu" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"q_trans\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nparams) + "},\"block\":\"parameters\"},{\"name\":\"coef\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(C) + "},\"block\":\"transformed_parameters\"},{\"name\":\"E_trans\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(C) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"q\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nparams) + "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(C) + "},\"block\":\"generated_quantities\"},{\"name\":\"mu\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(Nloc) + ",\"cols\":" + std::to_string(mu_2dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"q_trans\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nparams) + "},\"block\":\"parameters\"},{\"name\":\"coef\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(C) + "},\"block\":\"transformed_parameters\"},{\"name\":\"E_trans\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(C) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"q\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nparams) + "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(C) + "},\"block\":\"generated_quantities\"},{\"name\":\"mu\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(Nloc) + ",\"cols\":" + std::to_string(mu_2dim__) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((Nloc + Nloc) + nparams);
    const size_t num_transformed = emit_transformed_parameters * ((C + C));
    const size_t num_gen_quantities = emit_generated_quantities * (((nparams
      + C) + (Nloc * mu_2dim__)));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((Nloc + Nloc) + nparams);
    const size_t num_transformed = emit_transformed_parameters * ((C + C));
    const size_t num_gen_quantities = emit_generated_quantities * (((nparams
      + C) + (Nloc * mu_2dim__)));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_traditional_catchability_gamma_namespace::model_traditional_catchability_gamma;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_traditional_catchability_gamma_namespace::profiles__;
}
#endif
#endif
