% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{all_in}
\alias{all_in}
\alias{\%all_in\%}
\title{Check whether a vector are all elements of another vector}
\usage{
all_in(x, table)

x \%all_in\% table
}
\arguments{
\item{x}{The values to be matched.}

\item{table}{The values to be matched against.}
}
\description{
Check whether a vector are all elements of another vector
}
\examples{
\dontrun{
library(assertthat)
assert_that(c(1, 2) \%all_in\% c(0, 1, 2, 3, 4))
# TRUE

assert_that("a" \%all_in\% letters)
# TRUE

assert_that("A" \%all_in\% letters)
# Error: "A" is missing 1 element from letters: "A"

assert_that(1:10 \%all_in\% letters)
# Error: 1:10 is missing 10 elements from letters: 1, 2, 3, ...
}
}
