% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{project_to_segments}
\alias{project_to_segments}
\title{Project a set of points to to set of segments}
\usage{
project_to_segments(x, segment_start, segment_end)
}
\arguments{
\item{x}{a matrix of data points.}

\item{segment_start}{a matrix of segment start points.}

\item{segment_end}{a matrix of segment end points.}
}
\value{
A list with components
  \item{x_proj}{a matrix of projections of \code{x} onto the given segments.}
  \item{segment}{the index of the segment a point is projected on}
  \item{progression}{the progression of a projection along its segment}
  \item{distance}{the distance from each point in \code{x} to its projection in \code{x_proj}}
}
\description{
Finds the projection index for a matrix of points \code{x}, when
projected onto a set of segments defined by \code{segment_start} and \code{segment_end}.
}
\examples{
x <- matrix(rnorm(50, 0, .5), ncol = 2)
segfrom <- matrix(c(0, 1, 0, -1, 1, 0, -1, 0), ncol = 2, byrow = TRUE)
segto <- segfrom / 10
fit <- project_to_segments(x, segfrom, segto)

str(fit) # examine output

}
