% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xts_utilities.R
\name{resample_xts}
\alias{resample_xts}
\title{Functions to resample an xts time series}
\usage{
resample_xts(obs, dt, is.rate = FALSE)
}
\arguments{
\item{obs}{A times series (xts) object with a POSIXct index.}

\item{dt}{New time interval in seconds}

\item{is.rate}{If TRUE then these are rates i.e m/hr. Otherwise they are absolute values accumulated within the preceeding time interval. Values are scaled before returning so resampling is conservative.}
}
\value{
An xts object with the new timestep
}
\description{
Takes an xts time series object and resamples then to a new time step.
}
\details{
Time series of observation data are often of different temporal resolutions, however the input to most hydrological models, as is the case with the Dynamic TOPMODEL, requires those data at the same interval. This provides a method to resample a collection of such data to a single interval.

Because of the methods used the results:

- are not accurate when the input data does not have a constant timestep. The code issued a warnign and proceeds assuming the data are equally spaced with the modal timestep.
- do not guarentee the requested time step but returns a series with the timestep computed from an integer rounding the ratio of the current and requested time step.


}
\examples{
# Resample Swindale Rainfall to hourly intervals
require(dynatop)
data("Swindale")
obs <- Swindale$obs
cobs <- resample_xts(obs, dt=60*60) # hourly data
dobs <- resample_xts(cobs,dt=15*60) # back to 15 minute data
cdobs <- resample_xts(dobs,dt=60*60) # back to hourly data - checks time stamp conversion
obs <- obs[zoo::index(obs)<=max(zoo::index(cobs)),]

# check totals
stopifnot( all.equal(sum(obs),sum(cobs)) )
stopifnot( all.equal(sum(obs),sum(dobs)) )
stopifnot( all.equal(cobs,cdobs) )
}
