% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adci.R
\name{adci}
\alias{adci}
\title{Summaries of mosquito abundance}
\usage{
adci(
  input_sim = NULL,
  stage = NULL,
  sub_stage = NULL,
  breaks = c(0.25, 0.5, 0.75),
  eval_date = NULL,
  n.clusters = 1,
  type = "N"
)
}
\arguments{
\item{input_sim}{matrix. \code{dynamAedes} compressed or uncompressed output matrix.}

\item{stage}{character. "Eggs", "Juveniles", "Adults", or "DiapauseEggs" or any shorter attempt longer than 3 letters.}

\item{sub_stage}{character. For uncompressed outputs only, defines the substage of interest. Please see cheat-sheet table.}

\item{breaks}{numeric vector. Quantile breaks, default the first, the second and the third quartile: \code{c(0.25,0.5,0.75)}.}

\item{eval_date}{positive integer. Define the day to evaluate from the first day of introduction. Note that this can be particularly demanding in the case of spatial outputs.}

\item{n.clusters}{integer. Number of parallel processes.}

\item{type}{character. The type of output. Set "O" to force overall time-only summary over spatial. Default is "N" (normal).}
}
\value{
Returns a data frame or a raster with the summary of mosquito abundance at each life stage for each day.
}
\description{
Summaries of mosquito abundance at each life stage and sub-stage for each day.
}
\author{
Matteo Marcantonio \email{marcantoniomatteo@gmail.com}, Daniele Da Re \email{dare.daniele@gmail.com}
}
