% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sieve_default}
\alias{sieve_default}
\title{Test Criteria for Model Selection}
\format{
A list containing the parameters used for test criteria in model 
selection an \code{ddArray} objects. The \code{sieve_default} values are used as
a default in \code{\link{modelFilter}}. If desired, users may create their 
own tests, using \code{sieve_default} as a template. The same list elements
must all be present and have the same structure as the defaults, namely:
\describe{
 \item{\code{$aic}}{the cutoff for DeltaAIC scores; models with higher scores 
   are removed from further consideration. Default is \code{$aic = 10}}
 \item{\code{$hin}}{a boolean to indicate whether or not to use high leverage 
points as a criterion for model selection. Default is \code{$hin = TRUE}}
 \item{\code{$rtail}}{a vector of probabilities that the fitted model must 
   exceed at 80, 120, 150, and 200 meters. Default is 
   \code{rtail = c(p80 = 0.50, p120 = 0.90, p150 = 0.95, p200 = 0.99)}.
   Custom test parameters must be a vector probabilities with "p80", "p120",
   "p150", and "p200" in the names.}
 \item{\code{ltail}}{a vector of probabilities that a fitted model must 
   not exceed at 20 and 50 meters. Default is 
   \code{ltail = c(p20 = 0.50, p50 = 0.90)}. Custom test parameters must be
   a vector of probabilities with "p20" and "p50" in \code{names}.}
}
}
\usage{
sieve_default
}
\description{
Test Criteria for Model Selection
}
\keyword{datasets}
