% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{trim}
\alias{trim}
\title{Trim Tail Values off of a Vector}
\usage{
trim(x, p = NULL, tails = "both", cutpoints = NULL, keep.edge = TRUE)
}
\arguments{
\item{x}{Numeric vector.}

\item{p}{Numeric value giving tail probability to trim from \code{x}. Can 
leave as \code{NULL} if you specify \code{cutpoints}.}

\item{tails}{Numeric value indicating which tail should be trimmed. Possible 
values are \code{"both"}, \code{"lower"}, and \code{"upper"}.}

\item{cutpoints}{Numeric vector indicating what range of values should be 
retained. For example, set to \code{c(0, 1)} to trim all values below 0 or 
greater than 1. Can leave as \code{NULL} if you specify \code{p}.}

\item{keep.edge}{Logical value indicating whether values in \code{x} that are 
on the edge of being trimmed (i.e. equal to one of the endpoints) should be 
retained.}
}
\value{
Numeric vector.
}
\description{
Returns input vector with tail values trimmed off of it. User can specify 
tail probability to trim or lower and upper cutpoints for values to retain.
}
\examples{
# Generate data from N(0, 1) and then trim the lower and upper 1\\\%
x <- rnorm(1000)
y <- trim(x, p = 0.01)

# Generate data from N(0, 1) and then trim values outside of (-1.5, 1.5)
x <- rnorm(100000)
y <- trim(x, cutpoints = c(-1.5, 1.5))

}
\seealso{
\code{\link{inside}}
}
