% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{a2p}
\alias{a2p}
\alias{p2a}
\title{Convert probability parameters to probabilities}
\usage{
a2p(a)

p2a(p)
}
\arguments{
\item{a}{a vector of parameters}

\item{p}{a vector of probabilities with sum(p) = 1}
}
\description{
\code{\link{mphcrm}} parametrizes the probabilities that it optimizes.
For \eqn{n+1} probabilities there are \eqn{n} parameters \eqn{a_j}, such that
probability \eqn{P_i = \frac{a_i}{\sum_j \exp(a_j)}}, where we assume that \eqn{a_0 = 0}.
}
\examples{
# Draw 5 parameters
a <- rnorm(5)
a
# make 6 probabilities
p <- a2p(a)
p
# convert back
p2a(p)

}
