% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{combine_list_rules}
\alias{combine_list_rules}
\title{Combine Rules Found in Lists of Rules.}
\usage{
combine_list_rules(x, val, ...)
}
\arguments{
\item{x}{(\code{list}) of \code{rule} objects.}

\item{val}{(\code{list}) of \code{rule} objects.}

\item{...}{passed to \code{\link{combine_rules}}.}
}
\value{
a \code{list} of \code{rule} objects.
}
\description{
Combine Rules Found in Lists of Rules.
}
\examples{
l1 <- list(
  r1 = rule(
    "first" = c("overwritten", "OVERWRITTEN"),
    "almost first" = c(NA, "almost")
  ),
  r2 = rule(
    ANYTHING = "anything"
  )
)

l2 <- list(
  r1 = rule(
    "first" = c("F", "f"),
    "second" = c("S", "s"),
    "third" = c("T", "t"),
    .to_NA = "something"
  ),
  r3 = rule(
    SOMETHING = "something"
  )
)

combine_list_rules(l1, l2)
}
