% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Driver.R, R/dbConnect__duckdb_driver.R,
%   R/dbDisconnect__duckdb_connection.R
\name{duckdb}
\alias{duckdb}
\alias{duckdb_shutdown}
\alias{dbConnect__duckdb_driver}
\alias{dbConnect,duckdb_driver-method}
\alias{dbDisconnect__duckdb_connection}
\alias{dbDisconnect,duckdb_connection-method}
\title{Connect to a DuckDB database instance}
\usage{
duckdb(dbdir = DBDIR_MEMORY, read_only = FALSE, config = list())

duckdb_shutdown(drv)

\S4method{dbConnect}{duckdb_driver}(
  drv,
  dbdir = DBDIR_MEMORY,
  ...,
  debug = getOption("duckdb.debug", FALSE),
  read_only = FALSE,
  timezone_out = "UTC",
  tz_out_convert = c("with", "force"),
  config = list()
)

\S4method{dbDisconnect}{duckdb_connection}(conn, ..., shutdown = FALSE)
}
\arguments{
\item{dbdir}{Location for database files. Should be a path to an existing
directory in the file system. With the default, all
data is kept in RAM}

\item{read_only}{Set to \code{TRUE} for read-only operation}

\item{config}{Named list with DuckDB configuration flags}

\item{drv}{Object returned by \code{duckdb()}}

\item{...}{Ignored}

\item{debug}{Print additional debug information such as queries}

\item{timezone_out}{The time zone returned to R, defaults to \code{"UTC"}, which
is currently the only timezone supported by duckdb.
If you want to display datetime values in the local timezone,
set to \code{\link[=Sys.timezone]{Sys.timezone()}} or \code{""}.}

\item{tz_out_convert}{How to convert timestamp columns to the timezone specified
in \code{timezone_out}. There are two options: \code{"with"}, and \code{"force"}. If \code{"with"}
is chosen, the timestamp will be returned as it would appear in the specified time zone.
If \code{"force"} is chosen, the timestamp will have the same clock
time as the timestamp in the database, but with the new time zone.}

\item{conn}{A \code{duckdb_connection} object}

\item{shutdown}{Set to \code{TRUE} to shut down the DuckDB database instance that this connection refers to.}
}
\value{
\code{duckdb()} returns an object of class \linkS4class{duckdb_driver}.

\code{dbDisconnect()} and \code{duckdb_shutdown()} are called for their
side effect.

\code{dbConnect()} returns an object of class
\linkS4class{duckdb_connection}.
}
\description{
\code{duckdb()} creates or reuses a database instance.

\code{duckdb_shutdown()} shuts down a database instance.

\code{dbConnect()} connects to a database instance.

\code{dbDisconnect()} closes a DuckDB database connection, optionally shutting down
the associated instance.
}
\examples{
drv <- duckdb()
con <- dbConnect(drv)

dbGetQuery(con, "SELECT 'Hello, world!'")

dbDisconnect(con)
duckdb_shutdown(drv)

# Shorter:
con <- dbConnect(duckdb())
dbGetQuery(con, "SELECT 'Hello, world!'")
dbDisconnect(con, shutdown = TRUE)
}
