//===----------------------------------------------------------------------===//
//                         DuckDB
//
// duckdb/parser/qualified_name.hpp
//
//
//===----------------------------------------------------------------------===//

#pragma once

#include "duckdb/common/string.hpp"

namespace duckdb {

struct QualifiedName {
	string schema;
	string name;
};

struct QualifiedColumnName {
	QualifiedColumnName(){}
	QualifiedColumnName(string table_p, string column_p) : table(move(table_p)), column(move(column_p)) {}

	string schema;
	string table;
	string column;
};

} // namespace duckdb
