% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtts.R
\name{ops}
\alias{ops}
\alias{ops,data.table,data.table,character-method}
\title{Arithmetic operations on two \code{data.table} time-series}
\usage{
ops(x, y, op_string)

\S4method{ops}{data.table,data.table,character}(x, y, op_string)
}
\arguments{
\item{x}{the \code{data.table} time-series that determines the
left operand}

\item{y}{the \code{data.table} time-series that determines the
right operand \code{nanoperiod}.}

\item{op_string}{string defining the operation to apply; the
supported values for \code{op} are "*", "/", "+", "-".}
}
\description{
\code{ops} returns the \code{y} time-series on which the \code{x}
time-series values are applied using the specified operator
\code{op}.
}
\section{Details}{


The n elements of the \code{x} time-series operand define a set of
n-1 intervals, and the value associated with each interval is
applied to all the observations in the \code{y} time-series
operand that fall in the interval. Note that the interval is
closed at the beginning and open at the end. The supported values
for \code{op} are "*", "/", "+", "-".

There has to be one numeric column in \code{x} and \code{y}; there
has to be either a one to one correspondance between the number of
numeric columns in \code{x} and \code{y}, or there must be only
one numeric column in \code{x} that will be applied to all numeric
columns in \code{y}. Non-numeric columns must not appear in
\code{x}, whereas they will be skipped of they appear in \code{y}.
}

\examples{
\dontrun{
one_second_duration  <- as.nanoduration("00:00:01")
t1 <- nanotime(1:2 * one_second_duration * 3)
t2 <- nanotime(1:4 * one_second_duration)
dt1 <- data.table(index=t1, data1 = 1:length(t1))
setkey(dt1, index)
dt2 <- data.table(index=t2, data1 = 1:length(t2))
setkey(dt2, index)
ops(dt1, dt2, "+")
}
}
