% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_DTRSurv.R
\name{print}
\alias{print}
\alias{print,DTRSurv-method}
\title{Print Analysis Results}
\usage{
\S4method{print}{DTRSurv}(x, ...)
}
\arguments{
\item{x}{A DTRSurv object. The value returned by dtrSurv().}

\item{...}{Ignored.}
}
\value{
No return value, called to display key results.
}
\description{
Prints the key results of the analysis.
}
\examples{


dt <- data.frame("Y.1" = sample(1:100,100,TRUE), "Y.2" = sample(101:200,100,TRUE),
                 "D.1" = rbinom(100, 1, 0.9), "D.2" = rbinom(100,1,0.9),
                 "A.1" = rbinom(100, 1, 0.5), "A.2" = rbinom(100,1,0.5),
                 "X.1" = rnorm(100), "X.2" = rnorm(100))

result <- dtrSurv(data = dt, 
                  txName = c("A.1", "A.2"), 
                  models = list(Surv(Y.1,D.1)~X.1+A.1, 
                                Surv(Y.2,D.2)~X.2+A.2+Y.1))

print(x = result)
}
