% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normhnorm.R
\name{dnormhnorm}
\alias{dnormhnorm}
\alias{pnormhnorm}
\alias{qnormhnorm}
\alias{rnormhnorm}
\title{Normal-halfnormal distribution}
\usage{
dnormhnorm(
  x,
  mu = 0,
  sigma_v = 1,
  sigma_u = 1,
  s = -1,
  deriv = 0,
  tri = NULL,
  log.p = FALSE
)

pnormhnorm(
  q,
  mu = 0,
  sigma_v = 1,
  sigma_u = 1,
  s = -1,
  deriv = 0,
  tri = NULL,
  lower.tail = TRUE,
  log.p = FALSE
)

qnormhnorm(
  p,
  mu = 0,
  sigma_v = 1,
  sigma_u = 1,
  s = -1,
  lower.tail = TRUE,
  log.p = FALSE
)

rnormhnorm(n, mu = 0, sigma_v = 1, sigma_u = 1, s = -1)
}
\arguments{
\item{x}{vector of quantiles.}

\item{mu}{vector of \eqn{\mu}}

\item{sigma_v}{vector of \eqn{\sigma_V}. Must be positive.}

\item{sigma_u}{vector of \eqn{\sigma_U}. Must be positive.}

\item{s}{\eqn{s=-1} for production and \eqn{s=1} for cost function.}

\item{deriv}{derivative of order \code{deriv} of the log density. Available are 1,2,3,4.}

\item{tri}{optional, index arrays for upper triangular matrices, generated by \code{\link[mgcv:trind.generator]{trind.generator()}} and supplied to \code{chainrule()}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}  otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
\code{dnormhnorm} gives the density, \code{pnormhnorm} give the distribution function, \code{qnormhnorm} gives the quantile function, and \code{rnormhnorm} generates random numbers, with given parameters. If the derivatives are calculated these are provided as the attributes \code{gradient}, \code{hessian}, \code{l3} and \code{l4} of the output of the density.
}
\description{
Probablitiy density function, distribution, quantile function and random number generation for the normal-halfnormal distribution.
}
\details{
A random variable \eqn{\mathcal{E}} follows a normal-halfnormal distribution if \eqn{\mathcal{E} = V + s \cdot U }, where \eqn{V \sim N(\mu, \sigma_V^2)} and \eqn{U \sim HN(\sigma_U^2)}.
The density is given by \deqn{f_\mathcal{E}(\epsilon)=\frac{1}{\sqrt{\sigma_V^2+\sigma_U^2}} \phi(\frac{\epsilon-\mu}{\sqrt{\sigma_V^2+\sigma_U^2}}) \Phi(s \frac{\sigma_U}{\sigma_V} \frac{x-\mu}{\sqrt{\sigma_V^2+\sigma_U^2}}) \qquad,}
where \eqn{s=-1} for production and \eqn{s=1} for cost function.
}
\section{Functions}{
\itemize{
\item \code{pnormhnorm()}: distribution function for the normal-halfnormal distribution.

\item \code{qnormhnorm()}: quantile function for the normal-halfnormal distribution.

\item \code{rnormhnorm()}: random number generation for the normal-halfnormal distribution.

}}
\examples{
pdf <- dnormhnorm(x=seq(-3, 3, by=0.1), mu=1, sigma_v=2, sigma_u=3, s=-1)
cdf <- pnormhnorm(q=seq(-3, 3, by=0.1), mu=1, sigma_v=2, sigma_u=3, s=-1)
q <- qnormhnorm(p=seq(0.1, 0.9, by=0.1), mu=1, sigma_v=2, sigma_u=3, s=-1)
r <- rnormhnorm(n=100, mu=1, sigma_v=2, sigma_u=3, s=-1)

}
\references{
\itemize{
\item \insertRef{aigner1977formulation}{dsfa}
\item \insertRef{kumbhakar2015practitioner}{dsfa}
\item \insertRef{schmidt2020analytic}{dsfa}
\item \insertRef{gradshteyn2014table}{dsfa}
\item \insertRef{azzalini2013skew}{dsfa}
}
}
