\name{genMineData}
\alias{genMineData}
\alias{build.diagonal.model}
\alias{build.input.models}

\title{Generate Data}
\description{Generate data for Monte Carlo experiments}
\usage{
    genMineData(umodel, ymodel, uinput=NULL, sampleT=100, 
      unoise=NULL, usd=1,ynoise=NULL, ysd=1, rng=NULL)
    build.input.models(all.data, max.lag=NULL)
    build.diagonal.model(multi.models)
}
\arguments{
    \item{umodel}{Model for input data.}
    \item{ymodel}{Model for output data.}
    \item{sampleT}{Number of periods of data to generate.}
    \item{unoise}{Input noise.}
    \item{usd}{Standard deviationof input noise.}
    \item{ynoise}{Output noise.}
    \item{ysd}{Standard deviation of output noise.}
    \item{rng}{RNG setting.}
    \item{multi.models}{}
    \item{all.data}{}
    \item{max.lag}{}
    \item{uinput}{}
}
\value{A TSdata object.}
\details{
    This function generates test data using specified models.
    umodel is used to generate data input data and
    ymodel is used to generate data corresponding output data.
    The result of umodel is used as input to ymodel so the input dimension of
    ymodel should be the output dimension of umodel. Typically the ymodel would
    be degenerate in some of the input variables so the effective inputs 
    are a subset.
    If noise is NULL then an normal noise will be generated by simulate.
    This will be iid N(0,I).
    The RNG will be set first if it is specified. 
    If unoise or ynoise are specified they should be as expected by simulate
    for the specified umodel and ymodel.
    
    \code{genMineData} uses \code{build.input.models} which makes a list of univariate 
    models, one for each series in \code{inputData(data)} and 
    \code{build.diagonal.model} which builds one diagonal model from a list 
    of models returned  by \code{build.input.models}. It uses the AR part only.
}

\seealso{
    \code{\link[dse1]{simulate}}
}

\examples{
    data("eg1.DSE.data.diff", package="dse1")
    umodel <- build.diagonal.model(
            build.input.models(eg1.DSE.data.diff, max.lag=2))
    z  <- TSdata(output=outputData(eg1.DSE.data.diff), 
                 input = inputData(eg1.DSE.data.diff))
    ymodel <- TSmodel(estVARXls(z, max.lag=3))   
    sim.data <- genMineData(umodel, ymodel)
}
\concept{DSE}
\keyword{ts}

%%\name{plot.mineStepwise}
%%\alias{plot.mineStepwise}
%%\title{Plot Mine Stepwise Object}
%%\description{plot.mineStepwise}
%%\usage{
%%    \method{plot}{mineStepwise}(x, ...)
%%}
%%\arguments{
%%    \item{x}{Object returned by mineStepwise.}
%%    \item{...}{(further arguments, currently disregarded).}
%%}
%%\value{None}
%%\section{Side Effects}{A plot}
%%\seealso{
%%    \code{\link{mineStepwise}}
%%}
%%\concept{DSE}
%%\keyword{ts}
%%\name{mineStepwise}
%%\alias{mineStepwise}
%%\title{Mine Stepwise}
%%\description{mineStepwise}
%%\usage{
%%    mineStepwise(data, essential.data=1,
%%	method="efroymson", f.crit=2, intercept=TRUE,
%%	subtract.means=FALSE,  standardize=FALSE, 
%%	lags.in=6, lags.out=6, trend=FALSE, plot.=TRUE)
%%}
%%\arguments{
%%    \item{data}{TSdata}
%%    \item{essential.data}{An integer vector indication important data.}
%%    \item{method}{method to pass to stepwise.}
%%    \item{f.crit}{See details.}
%%    \item{intercept}{See details.}
%%    \item{subtract.means}{See details.}
%%    \item{standardize}{See details.}
%%    \item{lags.in}{See details.}
%%    \item{lags.out}{See details.}
%%    \item{trend}{See details.}
%%    \item{plot.}{See details.}
%%}
%%\value{x}
%%\details{This documentation is out of date.
%%    Data should be of class TSdata. essential.data must have length 1.
%%    standardize and subtract means ...
%%    The result is a list with the results of stepwise,..., and
%%    several vectors indicating information about the columns of the matrix
%%    passed to stepwise: 
%%    io.indicator indicating an input (FALSE) or output (TRUE) variable
%%    v.indicator  indicating which series
%%    lag.indicator indicating the lag
%%    s.input.indicator and s.output.indicator are logic matrices
%%    \code{length(stepwise$rss)} by m and p respectively indicating if
%%    a series is included for each element of rss.
%%}
%%
%%\concept{DSE}
%%\keyword{ts}

