% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_sim.R
\name{daily_sim}
\alias{daily_sim}
\title{Create a simple, exemplary, seasonal, daily time series}
\usage{
daily_sim(n = 8, week_effect = 1, month_effect = 1, year_effect = 1,
  model = c(3, 1, 1), ar = c(-0.2, 0.5, 0.1), ma = -0.4, moving = T,
  week_cycles = 2, month_cycles = 3, year_cycles = 8)
}
\arguments{
\item{n}{length of time series in years}

\item{week_effect}{increase size of seasonal factor for day-of-the-week}

\item{month_effect}{increase size of seasonal factor for day-of-the-month}

\item{year_effect}{increase size of seasonal factor for day-of-the-year}

\item{model}{ARIMA model for trend and irregular component of series}

\item{ar}{coefficients for AR terms}

\item{ma}{coefficients for MA terms}

\item{moving}{should seasonal factors be moving (=T) or constant (=F)}

\item{week_cycles}{number of cycles per week}

\item{month_cycles}{number of cycles per month}

\item{year_cycles}{number of cycles per year}
}
\description{
Create a seasonal daily time series and its seasonal and non-seasonal components
}
\details{
The output is an xts time series containing the time series, the true seasonally adjusted series,

the day-of-the-week seasonal component, the day-of-the-month seasonal component and the

day-of-the-year seasonal component.
}
\examples{
time_series <- daily_sim(n=4, year_effect=3)
xtsplot(time_series[,1], font="sans") # Plot of the time series
xtsplot(time_series[,3:5], font="sans") # Plot of the seasonal factors
}
\author{
Daniel Ollech
}
