% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{cur_date}
\alias{cur_date}
\title{Current date (in yyyy-mm-dd or dd-mm-yyyy format).}
\usage{
cur_date(rev = FALSE, sep = "-")
}
\arguments{
\item{rev}{Boolean: Reverse from "yyyy-mm-dd" to "dd-mm-yyyy" format?
Default: \code{rev = FALSE}.}

\item{sep}{Character: Separator to use. 
Default: \code{sep = "-"}.}
}
\description{
\code{cur_date} provides a relaxed version of 
\code{Sys.time()} that is sufficient for most purposes.
}
\details{
\code{cur_date} returns \code{Sys.time()} 
(in "%Y-%m-%d" or "%d-%m-%Y" format) 
using current system settings.
 
By default, this corresponds to the "%Y-%m-%d" (or "%F")     
format used as the ISO 8601 standard. 

For more options, see the 
\code{date()} and \code{Sys.Date()} functions of \strong{base} R 
and the plethora of formatting options for \code{Sys.time()}.
}
\examples{
cur_date()
cur_date(sep = "/")
cur_date(rev = TRUE)
cur_date(rev = TRUE, sep = ".")

}
\seealso{
\code{date()} and \code{today()} functions of the \strong{lubridate} package; 
\code{date()}, \code{Sys.Date()}, and \code{Sys.time()} functions of \strong{base} R.

Other date and time functions: 
\code{\link{cur_time}()},
\code{\link{what_date}()},
\code{\link{what_day}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_week}()},
\code{\link{what_year}()}
}
\concept{date and time functions}
