% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimateG_loop}
\alias{estimateG_loop}
\title{estimateG_loop}
\usage{
estimateG_loop(validRows, A, W, DeltaA, DeltaY, tolg, verbose, stratify,
  returnModels, SL_g, glm_g, a_0, Qn, adapt_g, use_future, se_cv = "none",
  se_cvFolds = 10)
}
\arguments{
\item{validRows}{A \code{list} of length \code{cvFolds} containing the row
indexes of observations to include in validation fold.}

\item{A}{A vector of binary treatment assignment (assumed to be equal to 0 or
1)}

\item{W}{A \code{data.frame} of named covariates}

\item{DeltaA}{Indicator of missing treatment (assumed to be equal to 0 if
missing 1 if observed)}

\item{DeltaY}{Indicator of missing outcome (assumed to be equal to 0 if
missing 1 if observed)}

\item{tolg}{A numeric indicating the minimum value for estimates of the
propensity score.}

\item{verbose}{A boolean indicating whether to print status updates.}

\item{stratify}{A \code{boolean} indicating whether to estimate the missing
outcome regression separately for observations with \code{A} equal to 0/1
(if \code{TRUE}) or to pool across \code{A} (if \code{FALSE}).}

\item{returnModels}{A boolean indicating whether to return model fits for the
outcome regression, propensity score, and reduced-dimension regressions.}

\item{SL_g}{A vector of characters describing the super learner library to be
used for each of the regression (\code{DeltaA}, \code{A}, and
\code{DeltaY}). To use the same regression for each of the regressions (or
if there is no missing data in \code{A} nor \code{Y}), a single library may
be input.}

\item{glm_g}{A character describing a formula to be used in the call to
\code{glm} for the propensity score.}

\item{a_0}{A vector of fixed treatment values at which to return marginal
mean estimates.}

\item{Qn}{A \code{list} of estimates of the outcome regression for each value
in \code{a_0}. Only needed if \code{adapt_g = TRUE}.}

\item{adapt_g}{A boolean indicating whether propensity score is adaptive
to outcome regression.}

\item{use_future}{Should \code{future} be used for parallelization?}

\item{se_cv}{Should cross-validated nuisance parameter estimates be used
for computing standard errors?
Options are \code{"none"} = no cross-validation is performed; \code{"partial"} =
only applicable if Super Learner is used for nuisance parameter estimates;
\code{"full"} = full cross-validation is performed. See vignette for further
details. Ignored if \code{cvFolds > 1}, since then
cross-validated nuisance parameter estimates are used by default and it is
assumed that you want full cross-validated standard errors.}

\item{se_cvFolds}{If cross-validated nuisance parameter estimates are used
to compute standard errors, how many folds should be used in this computation.
If \code{se_cv = "partial"}, then this option sets the number of folds used
by the \code{SuperLearner} fitting procedure.}
}
\description{
Helper function to clean up internals of \code{drtmle} function
}
