% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sl_npreg.R
\name{predict.SL.npreg}
\alias{predict.SL.npreg}
\title{Predict method for SL.npreg}
\usage{
\method{predict}{SL.npreg}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class \code{"SL.npreg"}.}

\item{newdata}{The new data used to obtain predictions.}

\item{...}{Other arguments passed to predict.}
}
\description{
Method for predicting SL.npreg objects.
}
\examples{
# simulate data
set.seed(1234)
n <- 100
X <- data.frame(X1 = rnorm(n))
Y <- X$X1 + rnorm(n)
# fit npreg
fit <- SL.npreg(Y = Y, X = X, newX = X)
# predict on fit
newX <- data.frame(X1 = c(-1, 0, 1))
pred <- predict(fit$fit, newdata = newX)
#
}
