% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{ci.adaptive_iptw}
\alias{ci.adaptive_iptw}
\title{Confidence intervals for adaptive_iptw objects}
\usage{
\method{ci}{adaptive_iptw}(object, est = c("iptw_tmle"), level = 0.95,
  contrast = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{"adaptive_iptw"}}

\item{est}{A vector indicating for which estimators to return a
confidence interval. Possible estimators include the TMLE IPTW
(\code{"iptw_tmle"}, recommended), the one-step IPTW
(\code{"iptw_os"}, not recommended), the standard IPTW
(\code{"iptw"}, recommended only for comparison to the other two estimators).}

\item{level}{The nominal coverage probability of the desired confidence interval (should be
between 0 and 1). Default computes 95\% confidence intervals.}

\item{contrast}{Specifies the parameter for which to return confidence intervals.
If \code{contrast=NULL}, then confidence intervals for the
marginal means are computed. If instead, \code{contrast} is a numeric vector of ones, negative ones,
and zeros to define linear combinations of the various means (e.g., to estimate an average
treatment effect, see example). Finally, \code{contrast} can be a list with named functions
\code{f}, \code{f_inv}, \code{h}, and \code{fh_grad}. The first two functions should take
as input argument \code{eff}. Respectively, these specify which transformation
of the effect measure to compute the confidence interval for and the inverse
transformation to put the confidence interval back on the original scale. The function \code{h}
defines the contrast to be estimated and should take as input \code{est}, a vector
of the same length as \code{object$a_0}, and output the desired contrast. The function
\code{fh_grad} is the gradient of the function \code{h}. See examples and vignette for more information.}

\item{...}{Other options (not currently used).}
}
\value{
An object of class \code{"ci.adaptive_iptw"} with point estimates and
confidence intervals of the specified level.
}
\description{
Estimate confidence intervals for objects of class \code{"adaptive_iptw"}
}
\examples{
# load super learner
library(SuperLearner)
# fit adaptive_iptw
set.seed(123456)
n <- 200
W <- data.frame(W1 = runif(n), W2 = rnorm(n))
A <- rbinom(n,1,plogis(W$W1 - W$W2))
Y <- rbinom(n, 1, plogis(W$W1*W$W2*A))

fit1 <- adaptive_iptw(W = W, A = A, Y = Y, a_0 = c(1,0),
               SL_g=c("SL.glm","SL.mean","SL.step"),
               SL_Qr="SL.glm")

# get confidence intervals for each mean
ci_mean <- ci(fit1)

# get confidence intervals for ATE
ci_ATE <- ci(fit1, contrast = c(1,-1))

# get confidence intervals for risk ratio
# by inputting own contrast function
# this computes CI on log scale and back transforms
myContrast <- list(f = function(eff){ log(eff) },
                   f_inv = function(eff){ exp(eff) },
                   h = function(est){ est[1]/est[2] },
                   fh_grad =  function(est){ c(1/est[1],-1/est[2]) })
ci_RR <- ci(fit1, contrast = myContrast)
}
