% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/spline.plot.r
\name{spline.plot}
\alias{spline.plot}
\title{Plot Spline}
\usage{
spline.plot(dosecolumn = "", targetcolumn = "", k = 4, data_type = "", data = NA)
}
\arguments{
\item{dosecolumn}{Name of dose column.}

\item{targetcolumn}{Name of response column.}

\item{k}{Dimension of the basis used to represent the smooth term.}

\item{data_type}{Allowed values "continuous" or "dichotomous".}

\item{data}{Input dataframe.}
}
\value{
A plot of the spline-estimated dose-response function along with the actual data.
}
\description{
This function generates a spline model with the input dose and target response
columns, and plots the spline-estimated dose-response function with its upper and lower
95 percent confidence bounds in green and red respectively along with the actual data.
Note that the confidence bounds depicted on the plot are for the dose-response function
itself, and not for the raw data.
}
\examples{
# Produces and plots the spline model with confidence bounds.
# For the same plot with key metrics, see drsmooth().
# For continuous outcomes:
data(DRdata)
spline.plot("dose", "MF_Log",  k = 4, data_type = "continuous", data=DRdata)

# For dichotomous outcomes:
data(DIdata)
# If necessary, convert summarized dataframe into 1 row per case dataframe (see drsmooth::expand)
DIdata_expanded <- expand(dosecolumn = "Dose", targetcolumn = "Tumor", ncolumn = "n", data = DIdata)
spline.plot("Dose", "Tumor", k = 4, data_type = "dichotomous", data=DIdata_expanded)
}

