% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunDS.R
\name{RunDS}
\alias{RunDS}
\title{Compute drought duration and severity based on run theory}
\usage{
RunDS(DI, thre)
}
\arguments{
\item{DI}{The vector of the drought index (e.g., monthly SPI)}

\item{thre}{The threshold of drought index (e.g, -0.5,-1)}
}
\value{
The duration and severity of each drought event
}
\description{
The input data is monthly drought indices.
Duration is defined as the length of consecutive time series 
when drought index is below the threshold value (e.g., -1). 
Severity is defined as the summation of drought index below the threshold.
This analysis based on run theory is also referred to as threshold level method.
Here the standardized drought index (SDI) is used as 
the example to compute the drought characteristics. 
Other univariate and multivariate drought indices can also be used.
}
\examples{
X=runif(120, min = 0, max = 100) # 10-year monthly data
thre=-1 # specify the threshold value
fit<-SDI(X,ts=3)  # Compute the univariate drought index, such as SPI
z=matrix(t(fit$SDI),ncol=1) # Reshape the matrix to a vector
Res <- RunDS(z, thre)  # Compute the duration and severity 
}
\references{
Yevjevich V. (1967). An Objective Approach to Definitions and Investigations of  Continental Hydrologic Droughts. Hydrology Paper 23. Colorado State University, Fort Collins, CO.
}
