% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmm.R
\name{getDistribution.dmm}
\alias{getDistribution.dmm}
\title{Get the distributions of the DMM}
\usage{
\method{getDistribution}{dmm}(x, pos, all.pos = FALSE, internal = FALSE, ncpu = 2)
}
\arguments{
\item{x}{An object of class \code{dmm}}

\item{pos}{A positive integer giving the position along the sequence on which the distribution of the DMM should be computed}

\item{all.pos}{`FALSE` (default, evaluation at position index) ; `TRUE` (evaluation for all position indices)}

\item{internal}{`FALSE` (default) ; `TRUE` (for internal use of \link[drimmR]{distributions} function)}

\item{ncpu}{Default=2. Represents the number of cores used to parallelized computation. If ncpu=-1, then it uses all available cores.}
}
\value{
A vector or matrix of distribution probabilities
}
\description{
Evaluate the distribution of the DMM at a given position or at every position
}
\details{
Distribution at position l is evaluated by \eqn{\mu_{l} =\mu_0 \prod_{t=k}^{l} \ \pi_{\frac{t}{n}}}, \eqn{\forall l \ge k, k \in N^*} order of the DMM
}
\examples{
data(lambda, package = "drimmR")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq", fit.method="sum")
t <- 10
getDistribution(dmm,pos=t)
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}, \link[drimmR]{distributions}, \link[drimmR]{getStationaryLaw}
}
\author{
Alexandre Seiller
}
