% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{CronbachAlpha}
\alias{CronbachAlpha}
\title{Cronbach Alpha}
\usage{
CronbachAlpha(X)
}
\arguments{
\item{X}{Units x variables numeric data matrix.}
}
\value{
\item{as}{Cronbach's Alpha}
}
\description{
Computes the Cronbach Alpha index on a units x variables data matrix. It measures the internal reliability, i.e., the propensity of J variables of a data matrix (n units x J variables) to be concordantly correlated with a single factor (composite indicator).
}
\examples{
# Iris data 
# Loading the numeric variables of iris data
iris <- as.matrix(iris[,-5]) 

# standardizing the data
iris <- scale(iris)

# compute Cronbach's Alpha
as <- CronbachAlpha(iris)
}
\references{
Cronbach L. J. (1951) "Coefficient alpha and the internal structure of tests" <doi:10.1007/BF02310555>
}
\author{
Ionel Prunila, Maurizio Vichi
}
