% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{show_source}
\alias{show_source}
\title{Show how a target/import was produced.
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}}
\usage{
show_source(target, config, character_only = FALSE)
}
\arguments{
\item{target}{Symbol denoting the target or import
or a character vector if character_only is \code{TRUE}.}

\item{config}{A \code{\link[=drake_config]{drake_config()}} list.}

\item{character_only}{Logical, whether to interpret
\code{target} as a symbol (\code{FALSE}) or character vector
(\code{TRUE}).}
}
\description{
Show the command that produced a target
or indicate that the object or file was imported.
}
\examples{
\dontrun{
isolate_example("contain side effects", {
plan <- drake_plan(x = sample.int(15))
cache <- storr::storr_environment() # custom in-memory cache
make(plan, cache = cache)
config <- drake_config(plan, cache = cache, history = FALSE)
show_source(x, config)
})
}
}
