% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readd}
\alias{readd}
\title{Read and return a drake target/import from the cache.}
\usage{
readd(target, character_only = FALSE, path = getwd(), search = TRUE,
  cache = drake::get_cache(path = path, search = search, verbose = verbose),
  namespace = NULL, verbose = drake::default_verbose(),
  show_source = FALSE)
}
\arguments{
\item{target}{If \code{character_only} is \code{TRUE}, then
\code{target} is a character string naming the object to read.
Otherwise, \code{target} is an unquoted symbol with the name of the
object.}

\item{character_only}{logical, whether \code{name} should be treated
as a character or a symbol
(just like \code{character.only} in \code{\link[=library]{library()}}).}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{namespace}{optional character string,
name of the \code{storr} namespace to read from.}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\describe{
\item{0 or \code{FALSE}:}{print nothing.}
\item{1 or \code{TRUE}:}{print only targets to build.}
\item{2:}{in addition, print checks and cache info.}
\item{3:}{in addition, print any potentially missing items.}
\item{4:}{in addition, print imports. Full verbosity.}
}}

\item{show_source}{logical, option to show the command
that produced the target or indicate that the object
was imported (using \code{\link[=show_source]{show_source()}}).}
}
\value{
The cached value of the \code{target}.
}
\description{
Does not delete the item from the cache.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
readd(reg1) # Return imported object 'reg1' from the cache.
readd(small) # Return targets 'small' from the cache.
readd("large", character_only = TRUE) # Return 'large' from the cache.
# For external files, only the fingerprint/hash is stored.
readd(file_store("report.md"), character_only = TRUE)
})
}
}
\seealso{
\code{\link[=loadd]{loadd()}}, \code{\link[=cached]{cached()}},
\code{\link[=built]{built()}}, \code{link{imported}}, \code{\link[=drake_plan]{drake_plan()}},
\code{\link[=make]{make()}}
}
