% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migrate.R
\name{migrate_drake_project}
\alias{migrate_drake_project}
\title{Reconfigure an old project (built with drake <= 4.4.0)
to be compatible with later versions of drake.}
\usage{
migrate_drake_project(path = drake::default_cache_path(), jobs = 1)
}
\arguments{
\item{path}{Full path to the cache}

\item{jobs}{number of jobs for light parallelism.
(Disabled on Windows.)}
}
\value{
\code{TRUE} if the migration was successful, \code{FALSE} otherwise.
A migration is successful if the transition preserves target status:
that is, outdated targets remain outdated and up to date targets
remain up to date.
}
\description{
Deprecated on May 4, 2018.
Migrate a project/cache from drake 4.4.0 or earlier
to be compatible with the version of drake on your system.
}
\details{
Drake versions after 4.4.0
have a different internal structure for the cache.
This means projects built with drake 4.4.0 or before are not compatible
with projects built with a later version of drake.
The \code{migrate_drake_project()} function converts
an old cache to a format compatible with the version of drake
installed on your system.
Important note: build times and other non-essential metadata
are lost during migration.
A migration is successful if the transition preserves target status:
that is, outdated targets remain outdated and up to date targets
remain up to date. At the end, \code{migrate_drake_project()}
tells you whether the migration
is successful. If it is not successful,
\code{migrate_drake_project()} tells you where
it backed up your old project.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
# With drake 4.3.0:
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the old project.
# Now, install drake >= 5.0.0
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Error: cache is not back compatible.
# Convert the project's '.drake/' cache to the new format.
migrate_drake_project()
make(my_plan) # Everything is still up to date!
# Outdated objects from before migration
# should remain out of date afterwards.
config <- drake_config(my_plan)
outdated(config)
})
}
}
\seealso{
\code{\link[=rescue_cache]{rescue_cache()}}, \code{\link[=make]{make()}}
}
\keyword{internal}
