% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{gather_plan}
\alias{gather_plan}
\title{Write commands to combine several targets into one
or more overarching targets.}
\usage{
gather_plan(plan = NULL, target = "target", gather = "list")
}
\arguments{
\item{plan}{workflow plan data frame of prespecified targets}

\item{target}{name of the new aggregated target}

\item{gather}{function used to gather the targets. Should be
one of \code{\link{list}(...)}, \code{\link{c}(...)},
\code{\link{rbind}(...)}, or similar.}
}
\value{
A workflow plan data frame that aggregates multiple
prespecified targets into one additional target downstream.
}
\description{
Creates a new workflow plan data frame with a single new
target. This new target is a list, vector, or other aggregate of
a collection of existing targets in another workflow plan data frame.
}
\examples{
# Workflow plan for datasets:
datasets <- drake_plan(
  small = simulate(5),
  large = simulate(50))
# Create a new target that brings the datasets together.
gather_plan(datasets, target = "my_datasets")
# This time, the new target just appends the rows of 'small' and 'large'
# into a single matrix or data frame.
gathered <- gather_plan(
  datasets, target = "aggregated_data", gather = "rbind"
)
gathered
# For the complete workflow plan, row bind the pieces together.
my_plan <- rbind(datasets, gathered)
my_plan
}
